/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.ArrayColumnTypes;
import io.questdb.cairo.BaseRecordMetadata;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.ColumnTypes;
import io.questdb.cairo.SingleColumnType;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.map.FastMap;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.map.MapValue;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.StringSink;
import java.io.Closeable;

public class JoinRecordMetadata
extends BaseRecordMetadata
implements Closeable {
    private static final ColumnTypes keyTypes;
    private static final ColumnTypes valueTypes;
    private final Map map;
    private int refCount;

    public JoinRecordMetadata(CairoConfiguration configuration, int columnCount) {
        this.map = new FastMap(configuration.getSqlJoinMetadataPageSize(), keyTypes, valueTypes, columnCount * 2, 0.6);
        this.timestampIndex = -1;
        this.columnCount = 0;
        this.columnNameIndexMap = new CharSequenceIntHashMap(columnCount);
        this.columnMetadata = new ObjList(columnCount);
        this.refCount = 1;
    }

    public void add(CharSequence tableAlias, CharSequence columnName, int columnType, boolean indexFlag, int indexValueBlockCapacity, boolean symbolTableStatic) {
        int dot = Chars.indexOf(columnName, '.');
        MapKey key = this.map.withKey();
        if (dot == -1) {
            key.putStr(tableAlias);
        } else {
            assert (tableAlias == null);
            key.putStr(columnName, 0, dot);
        }
        key.putStr(columnName, dot + 1, columnName.length());
        MapValue value = key.createValue();
        if (!value.isNew()) {
            throw CairoException.instance(0).put("Duplicate column [name=").put(columnName).put(", tableAlias=").put(tableAlias).put(']');
        }
        value.putLong(0, this.columnCount++);
        StringSink b = Misc.getThreadLocalBuilder();
        TableColumnMetadata cm = dot == -1 ? new TableColumnMetadata(b.put(tableAlias).put('.').put(columnName).toString(), columnType, indexFlag, indexValueBlockCapacity, symbolTableStatic) : new TableColumnMetadata(Chars.toString(columnName), columnType, indexFlag, indexValueBlockCapacity, symbolTableStatic);
        this.columnMetadata.add(cm);
        key = this.map.withKey();
        key.putStr(null);
        key.putStr(columnName, dot + 1, columnName.length());
        value = key.createValue();
        if (value.isNew()) {
            value.putInt(0, this.columnCount - 1);
        } else {
            value.putInt(0, -1);
        }
    }

    public void copyColumnMetadataFrom(CharSequence alias, RecordMetadata fromMetadata) {
        int n = fromMetadata.getColumnCount();
        for (int i = 0; i < n; ++i) {
            this.add(alias, fromMetadata.getColumnName(i), fromMetadata.getColumnType(i), fromMetadata.isColumnIndexed(i), fromMetadata.getIndexValueBlockCapacity(i), fromMetadata.isSymbolTableStatic(i));
        }
    }

    @Override
    public void close() {
        if (--this.refCount < 1) {
            this.map.close();
        }
    }

    public void incrementRefCount() {
        ++this.refCount;
    }

    @Override
    public int getColumnIndexQuiet(CharSequence columnName, int lo, int hi) {
        MapKey key = this.map.withKey();
        int dot = Chars.indexOf(columnName, lo, '.');
        if (dot == -1) {
            key.putStr(null);
            key.putStr(columnName, lo, hi);
        } else {
            key.putStr(columnName, 0, dot);
            key.putStr(columnName, dot + 1, columnName.length());
        }
        MapValue value = key.findValue();
        if (value != null) {
            return value.getInt(0);
        }
        return -1;
    }

    public void setTimestampIndex(int index) {
        this.timestampIndex = index;
    }

    static {
        ArrayColumnTypes kt = new ArrayColumnTypes();
        kt.add(10);
        kt.add(10);
        keyTypes = kt;
        valueTypes = new SingleColumnType(4);
    }
}

