/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.join;

import io.questdb.cairo.sql.Record;
import io.questdb.std.BinarySequence;
import io.questdb.std.Long256;
import io.questdb.std.str.CharSink;

public class OuterJoinRecord
implements Record {
    private final int split;
    private final Record nullRecord;
    private Record master;
    private Record slave;
    private Record activeSlave;

    public OuterJoinRecord(int split, Record nullRecord) {
        this.split = split;
        this.nullRecord = nullRecord;
    }

    @Override
    public BinarySequence getBin(int col) {
        if (col < this.split) {
            return this.master.getBin(col);
        }
        return this.activeSlave.getBin(col - this.split);
    }

    @Override
    public long getBinLen(int col) {
        if (col < this.split) {
            return this.master.getBinLen(col);
        }
        return this.activeSlave.getBinLen(col - this.split);
    }

    @Override
    public boolean getBool(int col) {
        if (col < this.split) {
            return this.master.getBool(col);
        }
        return this.activeSlave.getBool(col - this.split);
    }

    @Override
    public byte getByte(int col) {
        if (col < this.split) {
            return this.master.getByte(col);
        }
        return this.activeSlave.getByte(col - this.split);
    }

    @Override
    public long getDate(int col) {
        if (col < this.split) {
            return this.master.getDate(col);
        }
        return this.activeSlave.getDate(col - this.split);
    }

    @Override
    public double getDouble(int col) {
        if (col < this.split) {
            return this.master.getDouble(col);
        }
        return this.activeSlave.getDouble(col - this.split);
    }

    @Override
    public float getFloat(int col) {
        if (col < this.split) {
            return this.master.getFloat(col);
        }
        return this.activeSlave.getFloat(col - this.split);
    }

    @Override
    public int getInt(int col) {
        if (col < this.split) {
            return this.master.getInt(col);
        }
        return this.activeSlave.getInt(col - this.split);
    }

    @Override
    public char getChar(int col) {
        if (col < this.split) {
            return this.master.getChar(col);
        }
        return this.activeSlave.getChar(col - this.split);
    }

    @Override
    public void getLong256(int col, CharSink sink) {
        if (col < this.split) {
            this.master.getLong256(col, sink);
        } else {
            this.activeSlave.getLong256(col - this.split, sink);
        }
    }

    @Override
    public Long256 getLong256A(int col) {
        if (col < this.split) {
            return this.master.getLong256A(col);
        }
        return this.activeSlave.getLong256A(col - this.split);
    }

    @Override
    public Long256 getLong256B(int col) {
        if (col < this.split) {
            return this.master.getLong256B(col);
        }
        return this.activeSlave.getLong256B(col - this.split);
    }

    @Override
    public long getLong(int col) {
        if (col < this.split) {
            return this.master.getLong(col);
        }
        return this.activeSlave.getLong(col - this.split);
    }

    @Override
    public long getRowId() {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getShort(int col) {
        if (col < this.split) {
            return this.master.getShort(col);
        }
        return this.activeSlave.getShort(col - this.split);
    }

    @Override
    public CharSequence getStr(int col) {
        if (col < this.split) {
            return this.master.getStr(col);
        }
        return this.activeSlave.getStr(col - this.split);
    }

    @Override
    public void getStr(int col, CharSink sink) {
        if (col < this.split) {
            this.master.getStr(col, sink);
        } else {
            this.activeSlave.getStr(col - this.split, sink);
        }
    }

    @Override
    public CharSequence getStrB(int col) {
        if (col < this.split) {
            return this.master.getStrB(col);
        }
        return this.activeSlave.getStrB(col - this.split);
    }

    @Override
    public int getStrLen(int col) {
        if (col < this.split) {
            return this.master.getStrLen(col);
        }
        return this.activeSlave.getStrLen(col - this.split);
    }

    @Override
    public CharSequence getSym(int col) {
        if (col < this.split) {
            return this.master.getSym(col);
        }
        return this.activeSlave.getSym(col - this.split);
    }

    @Override
    public long getTimestamp(int col) {
        if (col < this.split) {
            return this.master.getTimestamp(col);
        }
        return this.activeSlave.getTimestamp(col - this.split);
    }

    void hasSlave(boolean value) {
        if (value) {
            if (this.activeSlave != this.slave) {
                this.activeSlave = this.slave;
            }
        } else if (this.activeSlave != this.nullRecord) {
            this.activeSlave = this.nullRecord;
        }
    }

    void of(Record master, Record slave) {
        this.master = master;
        this.slave = slave;
        this.activeSlave = null;
    }
}

