/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.orderby;

import io.questdb.cairo.sql.DelegatingRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.orderby.LongTreeChain;
import io.questdb.griffin.engine.orderby.RecordComparator;

class SortedLightRecordCursor
implements DelegatingRecordCursor {
    private final LongTreeChain chain;
    private final RecordComparator comparator;
    private final LongTreeChain.TreeCursor chainCursor;
    private RecordCursor base;
    private Record baseRecord;

    public SortedLightRecordCursor(LongTreeChain chain, RecordComparator comparator) {
        this.chain = chain;
        this.comparator = comparator;
        this.chainCursor = chain.getCursor();
    }

    @Override
    public void close() {
        this.chain.clear();
        this.base.close();
    }

    @Override
    public long size() {
        return this.base.size();
    }

    @Override
    public Record getRecord() {
        return this.baseRecord;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.base.getSymbolTable(columnIndex);
    }

    @Override
    public boolean hasNext() {
        if (this.chainCursor.hasNext()) {
            this.base.recordAt(this.baseRecord, this.chainCursor.next());
            return true;
        }
        return false;
    }

    @Override
    public Record getRecordB() {
        return this.base.getRecordB();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.base.recordAt(record, atRowId);
    }

    @Override
    public void toTop() {
        this.chainCursor.toTop();
    }

    @Override
    public void of(RecordCursor base) {
        this.base = base;
        this.baseRecord = base.getRecord();
        Record placeHolderRecord = base.getRecordB();
        this.chain.clear();
        while (base.hasNext()) {
            this.chain.put(this.baseRecord.getRowId(), base, placeHolderRecord, this.comparator);
        }
        this.chainCursor.toTop();
    }
}

