/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.TableReaderRecord;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.std.Rows;

public abstract class AbstractDataFrameRecordCursor
implements RecordCursor {
    protected final TableReaderRecord recordA = new TableReaderRecord();
    protected final TableReaderRecord recordB = new TableReaderRecord();
    protected DataFrameCursor dataFrameCursor;

    @Override
    public void close() {
        if (this.dataFrameCursor != null) {
            this.dataFrameCursor.close();
            this.dataFrameCursor = null;
        }
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.dataFrameCursor.getSymbolTable(columnIndex);
    }

    @Override
    public Record getRecordB() {
        return this.recordB;
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        ((TableReaderRecord)record).jumpTo(Rows.toPartitionIndex(atRowId), Rows.toLocalRowID(atRowId));
    }

    abstract void of(DataFrameCursor var1, SqlExecutionContext var2);
}

