/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.Rows;

abstract class AbstractRecordListCursor
extends AbstractDataFrameRecordCursor {
    protected final DirectLongList rows;
    private long index;

    public AbstractRecordListCursor(DirectLongList rows) {
        this.rows = rows;
    }

    @Override
    public long size() {
        return this.rows.size();
    }

    protected abstract void buildTreeMap(SqlExecutionContext var1);

    @Override
    public boolean hasNext() {
        if (this.index > -1L) {
            long row = this.rows.get(this.index--);
            this.recordA.jumpTo(Rows.toPartitionIndex(row), Rows.toLocalRowID(row));
            return true;
        }
        return false;
    }

    @Override
    public void toTop() {
        this.index = this.rows.size() - 1;
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.rows.clear();
        this.buildTreeMap(executionContext);
        this.index = this.rows.size() - 1;
    }
}

