/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.std.Misc;
import org.jetbrains.annotations.Nullable;

public class DataFrameRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final boolean followsOrderByAdvice;
    private final Function filter;

    public DataFrameRecordCursorFactory(RecordMetadata metadata, DataFrameCursorFactory dataFrameCursorFactory, RowCursorFactory rowCursorFactory, boolean followsOrderByAdvice, @Nullable Function filter) {
        super(metadata, dataFrameCursorFactory);
        this.cursor = new DataFrameRecordCursor(rowCursorFactory, rowCursorFactory.isEntity(), filter);
        this.followsOrderByAdvice = followsOrderByAdvice;
        this.filter = filter;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followsOrderByAdvice;
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }

    @Override
    public void close() {
        Misc.free(this.filter);
    }
}

