/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursor;

public class DeferredSymbolIndexFilteredRowCursorFactory
implements RowCursorFactory {
    private final SymbolIndexFilteredRowCursor cursor;
    private final int columnIndex;
    private final String symbol;
    private int symbolKey = -2;

    public DeferredSymbolIndexFilteredRowCursorFactory(int columnIndex, String symbol, Function filter, boolean cachedIndexReaderCursor, int indexDirection) {
        this.columnIndex = columnIndex;
        this.symbol = symbol;
        this.cursor = new SymbolIndexFilteredRowCursor(columnIndex, filter, cachedIndexReaderCursor, indexDirection);
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        if (this.symbolKey == -2) {
            return EmptyRowCursor.INSTANCE;
        }
        return this.cursor.of(dataFrame);
    }

    @Override
    public void prepareCursor(TableReader tableReader) {
        this.symbolKey = tableReader.getSymbolMapReader(this.columnIndex).keyOf(this.symbol);
        if (this.symbolKey != -2) {
            this.cursor.of(this.symbolKey);
            this.cursor.prepare(tableReader);
        }
    }

    @Override
    public boolean isEntity() {
        return false;
    }
}

