/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;

public class DeferredSymbolIndexRowCursorFactory
implements RowCursorFactory {
    private final int columnIndex;
    private final boolean cachedIndexReaderCursor;
    private final String symbol;
    private int symbolKey;
    private final int indexDirection;

    public DeferredSymbolIndexRowCursorFactory(int columnIndex, String symbol, boolean cachedIndexReaderCursor, int indexDirection) {
        this.columnIndex = columnIndex;
        this.symbolKey = -2;
        this.symbol = symbol;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
        this.indexDirection = indexDirection;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        if (this.symbolKey == -2) {
            return EmptyRowCursor.INSTANCE;
        }
        return dataFrame.getBitmapIndexReader(this.columnIndex, this.indexDirection).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L);
    }

    @Override
    public void prepareCursor(TableReader tableReader) {
        int symbolKey = tableReader.getSymbolMapReader(this.columnIndex).keyOf(this.symbol);
        if (symbolKey != -2) {
            this.symbolKey = TableUtils.toIndexKey(symbolKey);
        }
    }

    @Override
    public boolean isEntity() {
        return false;
    }
}

