/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.EmptyTableRandomRecordCursor;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.IntObjHashMap;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnSubQueryRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final int columnIndex;
    private final Function filter;
    private final ObjList<RowCursorFactory> cursorFactories;
    private final IntObjHashMap<RowCursorFactory> factoriesA = new IntObjHashMap(64, 0.5, -5);
    private final IntObjHashMap<RowCursorFactory> factoriesB = new IntObjHashMap(64, 0.5, -5);
    private final RecordCursorFactory recordCursorFactory;
    private IntObjHashMap<RowCursorFactory> factories;

    public FilterOnSubQueryRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, @NotNull RecordCursorFactory recordCursorFactory, int columnIndex, @Nullable Function filter) {
        super(metadata, dataFrameCursorFactory);
        this.recordCursorFactory = recordCursorFactory;
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.factories = this.factoriesA;
        this.cursorFactories = new ObjList();
        this.cursor = new DataFrameRecordCursor(new HeapRowCursorFactory(this.cursorFactories), false, filter);
    }

    @Override
    public void close() {
        Misc.free(this.filter);
        this.recordCursorFactory.close();
        this.factoriesA.clear();
        this.factoriesB.clear();
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        StaticSymbolTable symbolTable = dataFrameCursor.getSymbolTable(this.columnIndex);
        IntObjHashMap<RowCursorFactory> targetFactories = this.factories == this.factoriesA ? this.factoriesB : this.factoriesA;
        this.cursorFactories.clear();
        targetFactories.clear();
        try (RecordCursor cursor = this.recordCursorFactory.getCursor(executionContext);){
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                int targetIndex;
                CharSequence symbol = record.getStr(0);
                int symbolKey = symbolTable.keyOf(symbol);
                if (symbolKey == -2 || (targetIndex = targetFactories.keyIndex(symbolKey)) <= -1) continue;
                int index = this.factories.keyIndex(symbolKey);
                RowCursorFactory rowCursorFactory = index < 0 ? this.factories.valueAtQuick(index) : (this.filter == null ? new SymbolIndexRowCursorFactory(this.columnIndex, symbolKey, false, 1) : new SymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolKey, this.filter, false, 1));
                targetFactories.putAt(targetIndex, symbolKey, rowCursorFactory);
                this.cursorFactories.add(rowCursorFactory);
            }
        }
        this.factories.clear();
        this.factories = targetFactories;
        if (targetFactories.size() == 0) {
            dataFrameCursor.close();
            return EmptyTableRandomRecordCursor.INSTANCE;
        }
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

