/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursorFactory;
import io.questdb.griffin.engine.table.DataFrameRecordCursor;
import io.questdb.griffin.engine.table.DeferredSymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.DeferredSymbolIndexRowCursorFactory;
import io.questdb.griffin.engine.table.HeapRowCursorFactory;
import io.questdb.griffin.engine.table.SequentialRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexFilteredRowCursorFactory;
import io.questdb.griffin.engine.table.SymbolIndexRowCursorFactory;
import io.questdb.std.Chars;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilterOnValuesRecordCursorFactory
extends AbstractDataFrameRecordCursorFactory {
    private final DataFrameRecordCursor cursor;
    private final int columnIndex;
    private final Function filter;
    private final ObjList<RowCursorFactory> cursorFactories;
    private final boolean followedOrderByAdvice;

    public FilterOnValuesRecordCursorFactory(@NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, @NotNull ObjList<CharSequence> keyValues, int columnIndex, @NotNull TableReader reader, @Nullable Function filter, int orderByMnemonic, boolean followedOrderByAdvice, int indexDirection) {
        super(metadata, dataFrameCursorFactory);
        int nKeyValues = keyValues.size();
        this.columnIndex = columnIndex;
        this.filter = filter;
        this.cursorFactories = new ObjList(nKeyValues);
        SymbolMapReader symbolMapReader = reader.getSymbolMapReader(columnIndex);
        for (int i = 0; i < nKeyValues; ++i) {
            CharSequence symbol = keyValues.get(i);
            this.addSymbolKey(symbolMapReader.keyOf(symbol), symbol, indexDirection);
        }
        this.cursor = orderByMnemonic == 2 ? new DataFrameRecordCursor(new SequentialRowCursorFactory(this.cursorFactories), false, filter) : new DataFrameRecordCursor(new HeapRowCursorFactory(this.cursorFactories), false, filter);
        this.followedOrderByAdvice = followedOrderByAdvice;
    }

    @Override
    public boolean followedOrderByAdvice() {
        return this.followedOrderByAdvice;
    }

    @Override
    public void close() {
        Misc.free(this.filter);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    private void addSymbolKey(int symbolKey, CharSequence symbolValue, int indexDirection) {
        RowCursorFactory rowCursorFactory = this.filter == null ? (symbolKey == -2 ? new DeferredSymbolIndexRowCursorFactory(this.columnIndex, Chars.toString(symbolValue), this.cursorFactories.size() == 0, indexDirection) : new SymbolIndexRowCursorFactory(this.columnIndex, symbolKey, this.cursorFactories.size() == 0, indexDirection)) : (symbolKey == -2 ? new DeferredSymbolIndexFilteredRowCursorFactory(this.columnIndex, Chars.toString(symbolValue), this.filter, this.cursorFactories.size() == 0, indexDirection) : new SymbolIndexFilteredRowCursorFactory(this.columnIndex, symbolKey, this.filter, this.cursorFactories.size() == 0, indexDirection));
        this.cursorFactories.add(rowCursorFactory);
    }

    @Override
    protected RecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.cursor.of(dataFrameCursor, executionContext);
        if (this.filter != null) {
            this.filter.init(this.cursor, executionContext);
        }
        return this.cursor;
    }
}

