/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.Rows;

class LatestByAllIndexedRecordCursor
extends AbstractRecordListCursor {
    private final int columnIndex;
    private final IntHashSet found = new IntHashSet();

    public LatestByAllIndexedRecordCursor(int columnIndex, DirectLongList rows) {
        super(rows);
        this.columnIndex = columnIndex;
    }

    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) {
        DataFrame frame;
        this.found.clear();
        int keyCount = this.dataFrameCursor.getTableReader().getSymbolMapReader(this.columnIndex).size() + 1;
        int keyLo = 0;
        int keyHi = keyCount;
        int localLo = Integer.MAX_VALUE;
        int localHi = Integer.MIN_VALUE;
        while ((frame = this.dataFrameCursor.next()) != null && this.found.size() < keyCount) {
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            for (int i = keyLo; i < keyHi; ++i) {
                int index = this.found.keyIndex(i);
                if (index <= -1) continue;
                RowCursor cursor = indexReader.getCursor(false, i, rowLo, rowHi);
                if (cursor.hasNext()) {
                    this.rows.add(Rows.toRowID(frame.getPartitionIndex(), cursor.next()));
                    this.found.addAt(index, i);
                    continue;
                }
                if (i < localLo) {
                    localLo = i;
                }
                if (i <= localHi) continue;
                localHi = i;
            }
            keyLo = localLo;
            keyHi = localHi + 1;
            localLo = Integer.MAX_VALUE;
            localHi = Integer.MIN_VALUE;
        }
    }
}

