/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.Rows;

class LatestByAllRecordCursor
extends AbstractRecordListCursor {
    private final Map map;
    private final RecordSink recordSink;

    public LatestByAllRecordCursor(Map map, DirectLongList rows, RecordSink recordSink) {
        super(rows);
        this.map = map;
        this.recordSink = recordSink;
    }

    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) {
        DataFrame frame;
        this.map.clear();
        while ((frame = this.dataFrameCursor.next()) != null) {
            int partitionIndex = frame.getPartitionIndex();
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
            for (long row = rowHi; row >= rowLo; --row) {
                this.recordA.setRecordIndex(row);
                MapKey key = this.map.withKey();
                key.put(this.recordA, this.recordSink);
                if (!key.create()) continue;
                this.rows.add(Rows.toRowID(partitionIndex, row));
            }
        }
        this.map.clear();
    }
}

