/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordCursorFactory;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.cairo.sql.StaticSymbolTable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesRecordCursor;
import io.questdb.std.IntHashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestBySubQueryRecordCursorFactory
extends AbstractTreeSetRecordCursorFactory {
    private final int columnIndex;
    private final IntHashSet symbolKeys = new IntHashSet();
    private final RecordCursorFactory recordCursorFactory;
    private final Function filter;

    public LatestBySubQueryRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, @NotNull RecordCursorFactory recordCursorFactory, @Nullable Function filter, boolean indexed) {
        super(metadata, dataFrameCursorFactory, configuration);
        this.cursor = indexed ? (filter != null ? new LatestByValuesIndexedFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, filter) : new LatestByValuesIndexedRecordCursor(columnIndex, this.symbolKeys, this.rows)) : (filter != null ? new LatestByValuesFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, filter) : new LatestByValuesRecordCursor(columnIndex, this.rows, this.symbolKeys));
        this.columnIndex = columnIndex;
        this.recordCursorFactory = recordCursorFactory;
        this.filter = filter;
    }

    @Override
    public void close() {
        super.close();
        this.recordCursorFactory.close();
        if (this.filter != null) {
            this.filter.close();
        }
    }

    @Override
    protected AbstractDataFrameRecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        StaticSymbolTable symbolTable = dataFrameCursor.getSymbolTable(this.columnIndex);
        this.symbolKeys.clear();
        try (RecordCursor cursor = this.recordCursorFactory.getCursor(executionContext);){
            Record record = cursor.getRecord();
            while (cursor.hasNext()) {
                int symbolKey = symbolTable.keyOf(record.getSym(0));
                if (symbolKey == -2) continue;
                this.symbolKeys.add(TableUtils.toIndexKey(symbolKey));
            }
        }
        if (this.filter != null) {
            cursor = super.getCursorInstance(dataFrameCursor, executionContext);
            this.filter.init(cursor, executionContext);
            return cursor;
        }
        return super.getCursorInstance(dataFrameCursor, executionContext);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }
}

