/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.EmptyRowCursor;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.cairo.sql.RowCursorFactory;
import io.questdb.griffin.engine.table.LatestByValueIndexedRowCursor;

public class LatestByValueDeferredIndexedRowCursorFactory
implements RowCursorFactory {
    private final int columnIndex;
    private final String symbol;
    private final boolean cachedIndexReaderCursor;
    private final LatestByValueIndexedRowCursor cursor = new LatestByValueIndexedRowCursor();
    private int symbolKey;

    public LatestByValueDeferredIndexedRowCursorFactory(int columnIndex, String symbol, boolean cachedIndexReaderCursor) {
        this.columnIndex = columnIndex;
        this.symbol = symbol;
        this.symbolKey = -2;
        this.cachedIndexReaderCursor = cachedIndexReaderCursor;
    }

    @Override
    public RowCursor getCursor(DataFrame dataFrame) {
        RowCursor cursor;
        if (this.symbolKey != -2 && (cursor = dataFrame.getBitmapIndexReader(this.columnIndex, 2).getCursor(this.cachedIndexReaderCursor, this.symbolKey, dataFrame.getRowLo(), dataFrame.getRowHi() - 1L)).hasNext()) {
            this.cursor.of(cursor.next());
            return this.cursor;
        }
        return EmptyRowCursor.INSTANCE;
    }

    @Override
    public void prepareCursor(TableReader tableReader) {
        if (this.symbolKey == -2) {
            this.symbolKey = tableReader.getSymbolMapReader(this.columnIndex).keyOf(this.symbol);
            if (this.symbolKey != -2) {
                ++this.symbolKey;
            }
        }
    }

    @Override
    public boolean isEntity() {
        return false;
    }
}

