/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import org.jetbrains.annotations.NotNull;

class LatestByValueIndexedFilteredRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final int symbolKey;
    private final Function filter;
    private boolean hasNext;
    private boolean found;

    public LatestByValueIndexedFilteredRecordCursor(int columnIndex, int symbolKey, @NotNull Function filter) {
        this.columnIndex = columnIndex;
        this.symbolKey = symbolKey;
        this.filter = filter;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void toTop() {
        this.hasNext = this.found;
        this.filter.toTop();
    }

    private void findRecord() {
        DataFrame frame;
        block0: while ((frame = this.dataFrameCursor.next()) != null) {
            int partitionIndex = frame.getPartitionIndex();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(partitionIndex, 0L);
            RowCursor cursor = indexReader.getCursor(false, this.symbolKey, rowLo, rowHi);
            while (cursor.hasNext()) {
                this.recordA.setRecordIndex(cursor.next());
                if (!this.filter.getBool(this.recordA)) continue;
                this.found = true;
                break block0;
            }
        }
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.findRecord();
        this.hasNext = this.found;
        this.filter.init(this, executionContext);
    }
}

