/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;

class LatestByValueRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final int symbolKey;
    private boolean empty;
    private boolean hasNext;

    public LatestByValueRecordCursor(int columnIndex, int symbolKey) {
        this.columnIndex = columnIndex;
        this.symbolKey = symbolKey;
    }

    @Override
    public boolean hasNext() {
        if (this.hasNext) {
            this.hasNext = false;
            return true;
        }
        return false;
    }

    @Override
    public void toTop() {
        this.hasNext = !this.empty;
    }

    private void findRecord() {
        DataFrame frame;
        this.empty = true;
        block0: while ((frame = this.dataFrameCursor.next()) != null) {
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(frame.getPartitionIndex(), rowHi);
            for (long row = rowHi; row >= rowLo; --row) {
                this.recordA.setRecordIndex(row);
                int key = this.recordA.getInt(this.columnIndex);
                if (key != this.symbolKey) continue;
                this.empty = false;
                break block0;
            }
        }
    }

    @Override
    public long size() {
        return -1L;
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.findRecord();
        this.toTop();
    }
}

