/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractRecordListCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.Rows;

class LatestByValuesIndexedFilteredRecordCursor
extends AbstractRecordListCursor {
    private final int columnIndex;
    private final IntHashSet found = new IntHashSet();
    private final IntHashSet symbolKeys;
    private final Function filter;

    public LatestByValuesIndexedFilteredRecordCursor(int columnIndex, DirectLongList rows, IntHashSet symbolKeys, Function filter) {
        super(rows);
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
        this.filter = filter;
    }

    @Override
    public void toTop() {
        super.toTop();
        this.filter.toTop();
    }

    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) {
        DataFrame frame;
        int keyCount = this.symbolKeys.size();
        this.found.clear();
        while ((frame = this.dataFrameCursor.next()) != null && this.found.size() < keyCount) {
            int partitionIndex = frame.getPartitionIndex();
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            this.recordA.jumpTo(partitionIndex, 0L);
            int n = this.symbolKeys.size();
            for (int i = 0; i < n; ++i) {
                int symbolKey = this.symbolKeys.get(i);
                int index = this.found.keyIndex(symbolKey);
                if (index <= -1) continue;
                RowCursor cursor = indexReader.getCursor(false, symbolKey, rowLo, rowHi);
                while (cursor.hasNext()) {
                    long row = cursor.next();
                    this.recordA.setRecordIndex(row);
                    if (!this.filter.getBool(this.recordA)) continue;
                    this.rows.add(Rows.toRowID(partitionIndex, row));
                    this.found.addAt(index, symbolKey);
                }
            }
        }
    }
}

