/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.SymbolMapReader;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.DataFrameCursorFactory;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.griffin.engine.table.AbstractDeferredTreeSetRecordCursorFactory;
import io.questdb.griffin.engine.table.LatestByValuesIndexedFilteredRecordCursor;
import io.questdb.griffin.engine.table.LatestByValuesIndexedRecordCursor;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.DirectLongList;
import io.questdb.std.Misc;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LatestByValuesIndexedFilteredRecordCursorFactory
extends AbstractDeferredTreeSetRecordCursorFactory {
    private final Function filter;
    private final DirectLongList rowidList = new DirectLongList(0x100000L);

    public LatestByValuesIndexedFilteredRecordCursorFactory(@NotNull CairoConfiguration configuration, @NotNull RecordMetadata metadata, @NotNull DataFrameCursorFactory dataFrameCursorFactory, int columnIndex, CharSequenceHashSet keyValues, SymbolMapReader symbolMapReader, @Nullable Function filter) {
        super(configuration, metadata, dataFrameCursorFactory, columnIndex, keyValues, symbolMapReader);
        this.cursor = filter != null ? new LatestByValuesIndexedFilteredRecordCursor(columnIndex, this.rows, this.symbolKeys, filter) : new LatestByValuesIndexedRecordCursor(columnIndex, this.symbolKeys, this.rowidList);
        this.filter = filter;
    }

    @Override
    public void close() {
        super.close();
        if (this.filter != null) {
            this.filter.close();
        }
        Misc.free(this.rowidList);
    }

    @Override
    public boolean recordCursorSupportsRandomAccess() {
        return true;
    }

    @Override
    protected AbstractDataFrameRecordCursor getCursorInstance(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        if (this.filter != null) {
            AbstractDataFrameRecordCursor cursor = super.getCursorInstance(dataFrameCursor, executionContext);
            this.filter.init(cursor, executionContext);
            return cursor;
        }
        return super.getCursorInstance(dataFrameCursor, executionContext);
    }
}

