/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.DataFrameCursor;
import io.questdb.cairo.sql.RowCursor;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.table.AbstractDataFrameRecordCursor;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntHashSet;
import io.questdb.std.Rows;

class LatestByValuesIndexedRecordCursor
extends AbstractDataFrameRecordCursor {
    private final int columnIndex;
    private final IntHashSet found = new IntHashSet();
    private final IntHashSet symbolKeys;
    private final DirectLongList rows;
    private long index = 0L;

    public LatestByValuesIndexedRecordCursor(int columnIndex, IntHashSet symbolKeys, DirectLongList rows) {
        this.rows = rows;
        this.columnIndex = columnIndex;
        this.symbolKeys = symbolKeys;
    }

    @Override
    public void toTop() {
        this.index = this.rows.size() - 1;
    }

    protected void buildTreeMap() {
        DataFrame frame;
        int keyCount = this.symbolKeys.size();
        this.found.clear();
        this.rows.setPos(0L);
        while ((frame = this.dataFrameCursor.next()) != null && this.found.size() < keyCount) {
            BitmapIndexReader indexReader = frame.getBitmapIndexReader(this.columnIndex, 2);
            long rowLo = frame.getRowLo();
            long rowHi = frame.getRowHi() - 1L;
            int n = this.symbolKeys.size();
            for (int i = 0; i < n; ++i) {
                RowCursor cursor;
                int symbolKey = this.symbolKeys.get(i);
                int index = this.found.keyIndex(symbolKey);
                if (index <= -1 || !(cursor = indexReader.getCursor(false, symbolKey, rowLo, rowHi)).hasNext()) continue;
                long row = Rows.toRowID(frame.getPartitionIndex(), cursor.next());
                this.rows.add(row);
                this.found.addAt(index, symbolKey);
            }
        }
        this.index = this.rows.size() - 1;
    }

    @Override
    void of(DataFrameCursor dataFrameCursor, SqlExecutionContext executionContext) {
        this.dataFrameCursor = dataFrameCursor;
        this.recordA.of(dataFrameCursor.getTableReader());
        this.recordB.of(dataFrameCursor.getTableReader());
        this.buildTreeMap();
    }

    @Override
    public boolean hasNext() {
        if (this.index > -1L) {
            long rowid = this.rows.get(this.index);
            this.recordA.jumpTo(Rows.toPartitionIndex(rowid), Rows.toLocalRowID(rowid));
            --this.index;
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return this.rows.size();
    }
}

