/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.griffin.engine.AbstractRedBlackTree;

public class LongTreeSet
extends AbstractRedBlackTree {
    private final TreeCursor cursor = new TreeCursor();

    public LongTreeSet(int keyPageSize) {
        super(keyPageSize);
    }

    public TreeCursor getCursor() {
        this.cursor.toTop();
        return this.cursor;
    }

    public void put(long value) {
        long current;
        long parent;
        if (this.root == -1L) {
            this.putParent(value);
            return;
        }
        long p = this.root;
        do {
            parent = p;
            current = LongTreeSet.refOf(p);
            if (current > value) {
                p = LongTreeSet.leftOf(p);
                continue;
            }
            if (current < value) {
                p = LongTreeSet.rightOf(p);
                continue;
            }
            return;
        } while (p > -1L);
        p = this.allocateBlock();
        LongTreeSet.setParent(p, parent);
        LongTreeSet.setRef(p, value);
        if (current > value) {
            LongTreeSet.setLeft(parent, p);
        } else {
            LongTreeSet.setRight(parent, p);
        }
        this.fix(p);
    }

    public class TreeCursor {
        private long current;

        public boolean hasNext() {
            return this.current != -1L;
        }

        public long next() {
            long address = this.current;
            this.current = LongTreeSet.successor(this.current);
            return LongTreeSet.refOf(address);
        }

        public void toTop() {
            long p = LongTreeSet.this.root;
            if (p != -1L) {
                while (LongTreeSet.leftOf(p) != -1L) {
                    p = LongTreeSet.leftOf(p);
                }
            }
            this.current = p;
        }
    }
}

