/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.table.SelectedRecord;
import io.questdb.std.IntList;

class SelectedRecordCursor
implements RecordCursor {
    private final SelectedRecord recordA;
    private final SelectedRecord recordB;
    private final IntList columnCrossIndex;
    private RecordCursor baseCursor;

    public SelectedRecordCursor(IntList columnCrossIndex, boolean supportsRandomAccess) {
        this.recordA = new SelectedRecord(columnCrossIndex);
        this.recordB = supportsRandomAccess ? new SelectedRecord(columnCrossIndex) : null;
        this.columnCrossIndex = columnCrossIndex;
    }

    @Override
    public void close() {
        this.baseCursor.close();
    }

    @Override
    public Record getRecord() {
        return this.recordA;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.baseCursor.getSymbolTable(this.columnCrossIndex.getQuick(columnIndex));
    }

    @Override
    public long size() {
        return this.baseCursor.size();
    }

    @Override
    public boolean hasNext() {
        return this.baseCursor.hasNext();
    }

    @Override
    public Record getRecordB() {
        if (this.recordB != null) {
            return this.recordB;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public void recordAt(Record record, long atRowId) {
        this.baseCursor.recordAt(((SelectedRecord)record).getBaseRecord(), atRowId);
    }

    @Override
    public void toTop() {
        this.baseCursor.toTop();
    }

    void of(RecordCursor cursor) {
        this.baseCursor = cursor;
        this.recordA.of(cursor.getRecord());
        if (this.recordB != null) {
            this.recordB.of(cursor.getRecordB());
        }
    }
}

