/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.union;

import io.questdb.cairo.RecordSink;
import io.questdb.cairo.map.Map;
import io.questdb.cairo.map.MapKey;
import io.questdb.cairo.sql.NoRandomAccessRecordCursor;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.SymbolTable;
import io.questdb.griffin.engine.union.UnionRecord;
import io.questdb.std.Misc;

class UnionRecordCursor
implements NoRandomAccessRecordCursor {
    private final UnionRecord record = new UnionRecord();
    private final Map map;
    private final RecordSink recordSink;
    private RecordCursor masterCursor;
    private RecordCursor slaveCursor;
    private final NextMethod nextSlave = this::nextSlave;
    private Record masterRecord;
    private Record slaveRecord;
    private NextMethod nextMethod;
    private RecordCursor symbolCursor;
    private final NextMethod nextMaster = this::nextMaster;

    public UnionRecordCursor(Map map, RecordSink recordSink) {
        this.map = map;
        this.recordSink = recordSink;
    }

    void of(RecordCursor masterCursor, RecordCursor slaveCursor) {
        this.masterCursor = masterCursor;
        this.slaveCursor = slaveCursor;
        this.masterRecord = masterCursor.getRecord();
        this.slaveRecord = slaveCursor.getRecord();
        this.map.clear();
        this.toTop();
    }

    @Override
    public void close() {
        Misc.free(this.masterCursor);
        Misc.free(this.slaveCursor);
    }

    @Override
    public Record getRecord() {
        return this.record;
    }

    @Override
    public boolean hasNext() {
        return this.nextMethod.next();
    }

    private boolean nextSlave() {
        boolean next;
        while (next = this.slaveCursor.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.record, this.recordSink);
            if (!key.create()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SymbolTable getSymbolTable(int columnIndex) {
        return this.symbolCursor.getSymbolTable(columnIndex);
    }

    private boolean nextMaster() {
        if (this.masterCursor.hasNext()) {
            MapKey key = this.map.withKey();
            key.put(this.record, this.recordSink);
            key.create();
            return true;
        }
        return this.switchToSlaveCursor();
    }

    private boolean switchToSlaveCursor() {
        this.record.of(this.slaveRecord);
        this.nextMethod = this.nextSlave;
        this.symbolCursor = this.slaveCursor;
        return this.nextMethod.next();
    }

    @Override
    public void toTop() {
        this.map.clear();
        this.record.of(this.masterRecord);
        this.nextMethod = this.nextMaster;
        this.symbolCursor = this.masterCursor;
        this.masterCursor.toTop();
        this.slaveCursor.toTop();
    }

    @Override
    public long size() {
        return -1L;
    }

    static interface NextMethod {
        public boolean next();
    }
}

