/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;

public class InsertModel
implements ExecutionModel,
Mutable,
Sinkable {
    public static final ObjectFactory<InsertModel> FACTORY = InsertModel::new;
    private final CharSequenceHashSet columnSet = new CharSequenceHashSet();
    private final ObjList<ExpressionNode> columnValues = new ObjList();
    private final IntList columnPositions = new IntList();
    private ExpressionNode tableName;
    private QueryModel queryModel;
    private int selectKeywordPosition;
    private int endOfValuesPosition;

    private InsertModel() {
    }

    public boolean addColumn(CharSequence columnName, int columnPosition) {
        if (this.columnSet.add(columnName)) {
            this.columnPositions.add(columnPosition);
            return true;
        }
        return false;
    }

    public void addColumnValue(ExpressionNode value) {
        this.columnValues.add(value);
    }

    @Override
    public void clear() {
        this.tableName = null;
        this.queryModel = null;
        this.columnSet.clear();
        this.columnPositions.clear();
        this.columnValues.clear();
        this.selectKeywordPosition = 0;
        this.endOfValuesPosition = 0;
    }

    public int getColumnPosition(int columnIndex) {
        return this.columnPositions.getQuick(columnIndex);
    }

    public CharSequenceHashSet getColumnSet() {
        return this.columnSet;
    }

    public ObjList<ExpressionNode> getColumnValues() {
        return this.columnValues;
    }

    public int getSelectKeywordPosition() {
        return this.selectKeywordPosition;
    }

    public void setSelectKeywordPosition(int selectKeywordPosition) {
        this.selectKeywordPosition = selectKeywordPosition;
    }

    @Override
    public int getModelType() {
        return 4;
    }

    public QueryModel getQueryModel() {
        return this.queryModel;
    }

    public void setQueryModel(QueryModel queryModel) {
        this.queryModel = queryModel;
    }

    public ExpressionNode getTableName() {
        return this.tableName;
    }

    public void setTableName(ExpressionNode tableName) {
        this.tableName = tableName;
    }

    public int getEndOfValuesPosition() {
        return this.endOfValuesPosition;
    }

    public void setEndOfValuesPosition(int endOfValuesPosition) {
        this.endOfValuesPosition = endOfValuesPosition;
    }

    @Override
    public void toSink(CharSink sink) {
        int i;
        sink.put("insert into ").put(this.tableName.token).put(' ');
        int n = this.columnSet.size();
        if (n > 0) {
            sink.put('(');
            for (i = 0; i < n; ++i) {
                if (i > 0) {
                    sink.put(", ");
                }
                sink.put(this.columnSet.get(i));
            }
            sink.put(") ");
        }
        if (this.queryModel != null) {
            this.queryModel.toSink(sink);
        } else {
            sink.put("values (");
            int m = this.columnValues.size();
            for (i = 0; i < m; ++i) {
                if (i > 0) {
                    sink.put(", ");
                }
                sink.put(this.columnValues.getQuick(i));
            }
            sink.put(')');
        }
    }
}

