/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.griffin.SqlException;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.QueryModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.LongList;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjectFactory;
import io.questdb.std.microtime.DateFormatUtils;
import io.questdb.std.microtime.Timestamps;

public class IntrinsicModel
implements Mutable {
    public static final ObjectFactory<IntrinsicModel> FACTORY = IntrinsicModel::new;
    public static final int TRUE = 1;
    public static final int FALSE = 2;
    public static final int UNDEFINED = 0;
    private static final LongList INFINITE_INTERVAL = new LongList();
    public final CharSequenceHashSet keyValues = new CharSequenceHashSet();
    public final IntList keyValuePositions = new IntList();
    private final LongList intervalsA = new LongList();
    private final LongList intervalsB = new LongList();
    private final LongList intervalsC = new LongList();
    public CharSequence keyColumn;
    public ExpressionNode filter;
    public LongList intervals;
    public int intrinsicValue = 0;
    public QueryModel keySubQuery;

    public static long getIntervalHi(LongList intervals, int pos) {
        return intervals.getQuick((pos << 1) + 1);
    }

    public static long getIntervalLo(LongList intervals, int pos) {
        return intervals.getQuick(pos << 1);
    }

    static void intersect(LongList a, LongList b, LongList out) {
        int sizeA = a.size() / 2;
        int sizeB = b.size() / 2;
        int intervalA = 0;
        int intervalB = 0;
        while (intervalA != sizeA && intervalB != sizeB) {
            long aLo = IntrinsicModel.getIntervalLo(a, intervalA);
            long aHi = IntrinsicModel.getIntervalHi(a, intervalA);
            long bLo = IntrinsicModel.getIntervalLo(b, intervalB);
            long bHi = IntrinsicModel.getIntervalHi(b, intervalB);
            if (aHi < bLo) {
                ++intervalA;
                continue;
            }
            if (IntrinsicModel.getIntervalLo(a, intervalA) > IntrinsicModel.getIntervalHi(b, intervalB)) {
                ++intervalB;
                continue;
            }
            IntrinsicModel.append(out, Math.max(aLo, bLo), Math.min(aHi, bHi));
            if (aHi < bHi) {
                ++intervalA;
                continue;
            }
            ++intervalB;
        }
    }

    static void invert(LongList intervals) {
        long last = Long.MIN_VALUE;
        int n = intervals.size();
        for (int i = 0; i < n; i += 2) {
            long lo = intervals.getQuick(i);
            long hi = intervals.getQuick(i + 1);
            intervals.setQuick(i, last);
            intervals.setQuick(i + 1, lo - 1L);
            last = hi + 1L;
        }
        intervals.extendAndSet(n + 1, Long.MAX_VALUE);
        intervals.extendAndSet(n, last);
    }

    static void parseIntervalEx(CharSequence seq, int lo, int lim, int position, LongList out) throws SqlException {
        int[] pos = new int[3];
        int p = -1;
        for (int i = lo; i < lim; ++i) {
            if (seq.charAt(i) != ';') continue;
            if (p > 1) {
                throw SqlException.$(position, "Invalid interval format");
            }
            pos[++p] = i;
        }
        block4 : switch (p) {
            case -1: {
                try {
                    IntrinsicModel.parseInterval(seq, lo, lim, out);
                    break;
                }
                catch (NumericException i) {
                    try {
                        long millis = DateFormatUtils.tryParse(seq, lo, lim);
                        IntrinsicModel.append(out, millis, millis);
                        break;
                    }
                    catch (NumericException e) {
                        throw SqlException.$(position, "Not a date");
                    }
                }
            }
            case 0: {
                IntrinsicModel.parseRange(seq, lo, pos[0], lim, position, out);
                break;
            }
            case 2: {
                int count;
                int period;
                try {
                    period = Numbers.parseInt(seq, pos[1] + 1, pos[2] - 1);
                }
                catch (NumericException e) {
                    throw SqlException.$(position, "Period not a number");
                }
                try {
                    count = Numbers.parseInt(seq, pos[2] + 1, lim);
                }
                catch (NumericException e) {
                    throw SqlException.$(position, "Count not a number");
                }
                IntrinsicModel.parseRange(seq, lo, pos[0], pos[1], position, out);
                char type = seq.charAt(pos[2] - 1);
                switch (type) {
                    case 'y': {
                        IntrinsicModel.addYearIntervals(period, count, out);
                        break block4;
                    }
                    case 'M': {
                        IntrinsicModel.addMonthInterval(period, count, out);
                        break block4;
                    }
                    case 'h': {
                        IntrinsicModel.addMillisInterval((long)period * 3600000000L, count, out);
                        break block4;
                    }
                    case 'm': {
                        IntrinsicModel.addMillisInterval((long)period * 60000000L, count, out);
                        break block4;
                    }
                    case 's': {
                        IntrinsicModel.addMillisInterval((long)period * 1000000L, count, out);
                        break block4;
                    }
                    case 'd': {
                        IntrinsicModel.addMillisInterval((long)period * 86400000000L, count, out);
                        break block4;
                    }
                }
                throw SqlException.$(position, "Unknown period: " + type + " at " + (p - 1));
            }
            default: {
                throw SqlException.$(position, "Invalid interval format");
            }
        }
    }

    static void parseInterval(CharSequence seq, int pos, int lim, LongList out) throws NumericException {
        if (lim - pos < 4) {
            throw NumericException.INSTANCE;
        }
        int p = pos;
        int year = Numbers.parseInt(seq, p, p += 4);
        boolean l = Timestamps.isLeapYear(year);
        if (IntrinsicModel.checkLen(p, lim)) {
            IntrinsicModel.checkChar(seq, p++, lim, '-');
            int month = Numbers.parseInt(seq, p, p += 2);
            IntrinsicModel.checkRange(month, 1, 12);
            if (IntrinsicModel.checkLen(p, lim)) {
                IntrinsicModel.checkChar(seq, p++, lim, '-');
                int day = Numbers.parseInt(seq, p, p += 2);
                IntrinsicModel.checkRange(day, 1, Timestamps.getDaysPerMonth(month, l));
                if (IntrinsicModel.checkLen(p, lim)) {
                    IntrinsicModel.checkChar(seq, p++, lim, 'T');
                    int hour = Numbers.parseInt(seq, p, p += 2);
                    IntrinsicModel.checkRange(hour, 0, 23);
                    if (IntrinsicModel.checkLen(p, lim)) {
                        IntrinsicModel.checkChar(seq, p++, lim, ':');
                        int min = Numbers.parseInt(seq, p, p += 2);
                        IntrinsicModel.checkRange(min, 0, 59);
                        if (IntrinsicModel.checkLen(p, lim)) {
                            IntrinsicModel.checkChar(seq, p++, lim, ':');
                            int sec = Numbers.parseInt(seq, p, p += 2);
                            IntrinsicModel.checkRange(sec, 0, 59);
                            if (p < lim) {
                                throw NumericException.INSTANCE;
                            }
                            out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L);
                            out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + (long)sec * 1000000L + 999999L);
                        } else {
                            out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L);
                            out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + (long)min * 60000000L + 59000000L + 999999L);
                        }
                    } else {
                        out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L);
                        out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + (long)hour * 3600000000L + 3540000000L + 59000000L + 999999L);
                    }
                } else {
                    out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L);
                    out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(day - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L);
                }
            } else {
                out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l));
                out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(month, l) + (long)(Timestamps.getDaysPerMonth(month, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L);
            }
        } else {
            out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(1, l));
            out.add(Timestamps.yearMicros(year, l) + Timestamps.monthOfYearMicros(12, l) + (long)(Timestamps.getDaysPerMonth(12, l) - 1) * 86400000000L + 82800000000L + 3540000000L + 59000000L + 999999L);
        }
    }

    static void append(LongList list, long lo, long hi) {
        long prevHi;
        int n = list.size();
        if (n > 0 && (prevHi = list.getQuick(n - 1) + 1L) >= lo) {
            list.setQuick(n - 1, hi);
            return;
        }
        list.add(lo);
        list.add(hi);
    }

    private static void parseRange(CharSequence seq, int lo, int p, int lim, int position, LongList out) throws SqlException {
        int period;
        char type = seq.charAt(lim - 1);
        try {
            period = Numbers.parseInt(seq, p + 1, lim - 1);
        }
        catch (NumericException e) {
            throw SqlException.$(position, "Range not a number");
        }
        try {
            IntrinsicModel.parseInterval(seq, lo, p, out);
            int n = out.size();
            out.setQuick(n - 1, Timestamps.addPeriod(out.getQuick(n - 1), type, period));
            return;
        }
        catch (NumericException n) {
            try {
                long loMillis = DateFormatUtils.tryParse(seq, lo, p);
                IntrinsicModel.append(out, loMillis, Timestamps.addPeriod(loMillis, type, period));
            }
            catch (NumericException e) {
                throw SqlException.invalidDate(position);
            }
            return;
        }
    }

    private static void addMillisInterval(long period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            IntrinsicModel.append(out, lo += period, hi += period);
        }
    }

    private static void addMonthInterval(int period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            lo = Timestamps.addMonths(lo, period);
            hi = Timestamps.addMonths(hi, period);
            IntrinsicModel.append(out, lo, hi);
        }
    }

    private static void addYearIntervals(int period, int count, LongList out) {
        int k = out.size();
        long lo = out.getQuick(k - 2);
        long hi = out.getQuick(k - 1);
        int n = count - 1;
        for (int i = 0; i < n; ++i) {
            lo = Timestamps.addYear(lo, period);
            hi = Timestamps.addYear(hi, period);
            IntrinsicModel.append(out, lo, hi);
        }
    }

    private static boolean checkLen(int p, int lim) throws NumericException {
        if (lim - p > 2) {
            return true;
        }
        if (lim <= p) {
            return false;
        }
        throw NumericException.INSTANCE;
    }

    private static void checkChar(CharSequence s, int p, int lim, char c) throws NumericException {
        if (p >= lim || s.charAt(p) != c) {
            throw NumericException.INSTANCE;
        }
    }

    private static void checkRange(int x, int min, int max) throws NumericException {
        if (x < min || x > max) {
            throw NumericException.INSTANCE;
        }
    }

    @Override
    public void clear() {
        this.keyColumn = null;
        this.keyValues.clear();
        this.keyValuePositions.clear();
        this.clearInterval();
        this.filter = null;
        this.intervals = null;
        this.intrinsicValue = 0;
        this.keySubQuery = null;
    }

    public void clearInterval() {
        this.intervals = null;
    }

    public void excludeValue(ExpressionNode val) {
        int index;
        if (Chars.equalsLowerCaseAscii(val.token, "null")) {
            index = this.keyValues.removeNull();
            if (index > -1) {
                this.keyValuePositions.removeIndex(index);
            }
        } else {
            int keyIndex;
            int n = keyIndex = Chars.isQuoted(val.token) ? this.keyValues.keyIndex(val.token, 1, val.token.length() - 1) : this.keyValues.keyIndex(val.token);
            if (keyIndex < 0) {
                index = this.keyValues.getListIndexAt(keyIndex);
                this.keyValues.removeAt(keyIndex);
            } else {
                index = -1;
            }
        }
        if (index > -1) {
            this.keyValuePositions.removeIndex(index);
        }
        if (this.keyValues.size() == 0) {
            this.intrinsicValue = 2;
        }
    }

    public void intersectIntervals(long lo, long hi) {
        LongList temp = this.shuffleTemp(this.intervals, null);
        temp.add(lo);
        temp.add(hi);
        this.intersectIntervals(temp);
    }

    public void intersectIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        LongList temp = this.shuffleTemp(this.intervals, null);
        IntrinsicModel.parseIntervalEx(seq, lo, lim, position, temp);
        this.intersectIntervals(temp);
    }

    public void subtractIntervals(long lo, long hi) {
        LongList temp = this.shuffleTemp(this.intervals, null);
        temp.add(lo);
        temp.add(hi);
        this.subtractIntervals(temp);
    }

    public void subtractIntervals(CharSequence seq, int lo, int lim, int position) throws SqlException {
        LongList temp = this.shuffleTemp(this.intervals, null);
        IntrinsicModel.parseIntervalEx(seq, lo, lim, position, temp);
        this.subtractIntervals(temp);
    }

    public String toString() {
        return "IntrinsicModel{keyValues=" + this.keyValues + ", keyColumn='" + this.keyColumn + '\'' + ", filter=" + this.filter + '}';
    }

    private void intersectIntervals(LongList intervals) {
        if (this.intervals == null) {
            this.intervals = intervals;
        } else {
            LongList dest = this.shuffleTemp(intervals, this.intervals);
            IntrinsicModel.intersect(intervals, this.intervals, dest);
            this.intervals = dest;
        }
        if (this.intervals.size() == 0) {
            this.intrinsicValue = 2;
        }
    }

    private LongList shuffleTemp(LongList src1, LongList src2) {
        LongList result = this.shuffleTemp0(src1, src2);
        result.clear();
        return result;
    }

    private LongList shuffleTemp0(LongList src1, LongList src2) {
        if (src2 != null) {
            if (src1 == this.intervalsA && src2 == this.intervalsB || src1 == this.intervalsB && src2 == this.intervalsA) {
                return this.intervalsC;
            }
            return this.intervalsB;
        }
        if (src1 == this.intervalsA) {
            return this.intervalsB;
        }
        return this.intervalsA;
    }

    private void subtractIntervals(LongList temp) {
        IntrinsicModel.invert(temp);
        if (this.intervals == null) {
            this.intervals = temp;
        } else {
            LongList dest = this.shuffleTemp(temp, this.intervals);
            IntrinsicModel.intersect(temp, this.intervals, dest);
            this.intervals = dest;
        }
        if (this.intervals.size() == 0) {
            this.intrinsicValue = 2;
        }
    }

    static {
        INFINITE_INTERVAL.add(Long.MIN_VALUE);
        INFINITE_INTERVAL.add(Long.MAX_VALUE);
    }
}

