/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.model;

import io.questdb.cairo.sql.Function;
import io.questdb.griffin.model.AliasTranslator;
import io.questdb.griffin.model.AnalyticColumn;
import io.questdb.griffin.model.ExecutionModel;
import io.questdb.griffin.model.ExpressionNode;
import io.questdb.griffin.model.JoinContext;
import io.questdb.griffin.model.QueryColumn;
import io.questdb.griffin.model.WithClauseModel;
import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.Chars;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Mutable;
import io.questdb.std.ObjList;
import io.questdb.std.ObjectFactory;
import io.questdb.std.Sinkable;
import io.questdb.std.str.CharSink;
import java.util.ArrayDeque;

public class QueryModel
implements Mutable,
ExecutionModel,
AliasTranslator,
Sinkable {
    public static final QueryModelFactory FACTORY = new QueryModelFactory();
    public static final int ORDER_DIRECTION_ASCENDING = 0;
    public static final int ORDER_DIRECTION_DESCENDING = 1;
    public static final String NO_ROWID_MARKER = "*!*";
    public static final int JOIN_INNER = 1;
    public static final int JOIN_OUTER = 2;
    public static final int JOIN_CROSS = 3;
    public static final int JOIN_ASOF = 4;
    public static final int JOIN_SPLICE = 5;
    public static final String SUB_QUERY_ALIAS_PREFIX = "_xQdbA";
    public static final int SELECT_MODEL_NONE = 0;
    public static final int SELECT_MODEL_CHOOSE = 1;
    public static final int SELECT_MODEL_VIRTUAL = 2;
    public static final int SELECT_MODEL_ANALYTIC = 3;
    public static final int SELECT_MODEL_GROUP_BY = 4;
    public static final int SELECT_MODEL_DISTINCT = 5;
    public static final int UNION_MODEL_ALL = 0;
    public static final int UNION_MODEL_DISTINCT = 1;
    private static final ObjList<String> modelTypeName = new ObjList();
    private final ObjList<QueryColumn> columns = new ObjList();
    private final CharSequenceHashSet topDownNameSet = new CharSequenceHashSet();
    private final ObjList<QueryColumn> topDownColumns = new ObjList();
    private final CharSequenceObjHashMap<CharSequence> aliasToColumnNameMap = new CharSequenceObjHashMap();
    private final CharSequenceObjHashMap<CharSequence> columnNameToAliasMap = new CharSequenceObjHashMap();
    private final CharSequenceObjHashMap<QueryColumn> aliasToColumnMap = new CharSequenceObjHashMap();
    private final ObjList<CharSequence> bottomUpColumnNames = new ObjList();
    private final ObjList<QueryModel> joinModels = new ObjList();
    private final ObjList<ExpressionNode> orderBy = new ObjList();
    private final IntList orderByDirection = new IntList();
    private final IntHashSet dependencies = new IntHashSet();
    private final IntList orderedJoinModels1 = new IntList();
    private final IntList orderedJoinModels2 = new IntList();
    private final CharSequenceIntHashMap aliasIndexes = new CharSequenceIntHashMap();
    private final ObjList<ExpressionNode> expressionModels = new ObjList();
    private final ObjList<ExpressionNode> parsedWhere = new ObjList();
    private final IntHashSet parsedWhereConsts = new IntHashSet();
    private final ArrayDeque<ExpressionNode> sqlNodeStack = new ArrayDeque();
    private final CharSequenceIntHashMap orderHash = new CharSequenceIntHashMap(4, 0.5, -1);
    private final ObjList<ExpressionNode> joinColumns = new ObjList(4);
    private final CharSequenceObjHashMap<WithClauseModel> withClauses = new CharSequenceObjHashMap();
    private final ObjList<ExpressionNode> sampleByFill = new ObjList();
    private final ObjList<ExpressionNode> latestBy = new ObjList();
    private final ObjList<ExpressionNode> orderByAdvice = new ObjList();
    private final IntList orderByDirectionAdvice = new IntList();
    private ExpressionNode whereClause;
    private ExpressionNode postJoinWhereClause;
    private ExpressionNode constWhereClause;
    private QueryModel nestedModel;
    private ExpressionNode tableName;
    private long tableVersion;
    private Function tableNameFunction;
    private ExpressionNode alias;
    private ExpressionNode timestamp;
    private ExpressionNode sampleBy;
    private JoinContext context;
    private ExpressionNode joinCriteria;
    private int joinType;
    private int joinKeywordPosition;
    private IntList orderedJoinModels = this.orderedJoinModels2;
    private ExpressionNode limitLo;
    private ExpressionNode limitHi;
    private int selectModelType = 0;
    private boolean nestedModelIsSubQuery = false;
    private boolean distinct = false;
    private QueryModel unionModel;
    private int unionModelType;
    private int modelPosition = 0;
    private int orderByAdviceMnemonic;

    private QueryModel() {
        this.joinModels.add(this);
    }

    public boolean addAliasIndex(ExpressionNode node, int index) {
        return this.aliasIndexes.put(node.token, index);
    }

    public void addBottomUpColumn(QueryColumn column) {
        this.columns.add(column);
        this.addField(column);
    }

    public void addDependency(int index) {
        this.dependencies.add(index);
    }

    public void addExpressionModel(ExpressionNode node) {
        assert (node.queryModel != null);
        this.expressionModels.add(node);
    }

    public void addField(QueryColumn column) {
        CharSequence alias = column.getAlias();
        ExpressionNode ast = column.getAst();
        assert (alias != null);
        this.aliasToColumnNameMap.put(alias, ast.token);
        this.columnNameToAliasMap.put(ast.token, alias);
        this.bottomUpColumnNames.add(alias);
        this.aliasToColumnMap.put(alias, column);
    }

    public void addJoinColumn(ExpressionNode node) {
        this.joinColumns.add(node);
    }

    public void addJoinModel(QueryModel model) {
        this.joinModels.add(model);
    }

    public void addLatestBy(ExpressionNode latestBy) {
        this.latestBy.add(latestBy);
    }

    public void addOrderBy(ExpressionNode node, int direction) {
        this.orderBy.add(node);
        this.orderByDirection.add(direction);
    }

    public void addParsedWhereNode(ExpressionNode node) {
        this.parsedWhere.add(node);
    }

    public void addSampleByFill(ExpressionNode sampleByFill) {
        this.sampleByFill.add(sampleByFill);
    }

    public void addTopDownColumn(QueryColumn column, CharSequence alias) {
        if (this.topDownNameSet.add(alias)) {
            this.topDownColumns.add(column);
        }
    }

    public void addWithClause(CharSequence name, WithClauseModel model) {
        this.withClauses.put(name, model);
    }

    @Override
    public void clear() {
        this.columns.clear();
        this.aliasToColumnNameMap.clear();
        this.joinModels.clear();
        this.joinModels.add(this);
        this.clearSampleBy();
        this.orderBy.clear();
        this.orderByDirection.clear();
        this.dependencies.clear();
        this.parsedWhere.clear();
        this.whereClause = null;
        this.constWhereClause = null;
        this.nestedModel = null;
        this.tableName = null;
        this.alias = null;
        this.latestBy.clear();
        this.joinCriteria = null;
        this.joinType = 1;
        this.joinKeywordPosition = 0;
        this.orderedJoinModels1.clear();
        this.orderedJoinModels2.clear();
        this.parsedWhereConsts.clear();
        this.aliasIndexes.clear();
        this.postJoinWhereClause = null;
        this.context = null;
        this.orderedJoinModels = this.orderedJoinModels2;
        this.limitHi = null;
        this.limitLo = null;
        this.timestamp = null;
        this.sqlNodeStack.clear();
        this.joinColumns.clear();
        this.withClauses.clear();
        this.selectModelType = 0;
        this.columnNameToAliasMap.clear();
        this.tableNameFunction = null;
        this.tableVersion = -1L;
        this.bottomUpColumnNames.clear();
        this.expressionModels.clear();
        this.distinct = false;
        this.nestedModelIsSubQuery = false;
        this.unionModel = null;
        this.orderHash.clear();
        this.modelPosition = 0;
        this.topDownColumns.clear();
        this.topDownNameSet.clear();
        this.aliasToColumnMap.clear();
    }

    public void clearColumnMapStructs() {
        this.aliasToColumnNameMap.clear();
        this.bottomUpColumnNames.clear();
        this.aliasToColumnMap.clear();
    }

    public void clearOrderBy() {
        this.orderBy.clear();
        this.orderByDirection.clear();
    }

    public void clearSampleBy() {
        this.sampleBy = null;
        this.sampleByFill.clear();
    }

    public void copyColumnsFrom(QueryModel other) {
        this.clearColumnMapStructs();
        this.aliasToColumnMap.putAll(other.aliasToColumnMap);
        ObjList<CharSequence> columnNames = other.bottomUpColumnNames;
        this.bottomUpColumnNames.addAll(columnNames);
        int n = columnNames.size();
        for (int i = 0; i < n; ++i) {
            CharSequence name = columnNames.getQuick(i);
            this.aliasToColumnNameMap.put(name, name);
        }
    }

    public void copyOrderByAdvice(ObjList<ExpressionNode> orderByAdvice) {
        this.orderByAdvice.clear();
        this.orderByAdvice.addAll(orderByAdvice);
    }

    public void copyOrderByDirectionAdvice(IntList orderByDirection) {
        this.orderByDirectionAdvice.clear();
        this.orderByDirectionAdvice.addAll(orderByDirection);
    }

    public ExpressionNode getAlias() {
        return this.alias;
    }

    public void setAlias(ExpressionNode alias) {
        this.alias = alias;
    }

    public int getAliasIndex(CharSequence column, int start, int end) {
        int index = this.aliasIndexes.keyIndex(column, start, end);
        if (index < 0) {
            return this.aliasIndexes.valueAt(index);
        }
        return -1;
    }

    public CharSequenceObjHashMap<QueryColumn> getAliasToColumnMap() {
        return this.aliasToColumnMap;
    }

    public CharSequenceObjHashMap<CharSequence> getAliasToColumnNameMap() {
        return this.aliasToColumnNameMap;
    }

    public ObjList<CharSequence> getBottomUpColumnNames() {
        return this.bottomUpColumnNames;
    }

    public CharSequenceObjHashMap<CharSequence> getColumnNameToAliasMap() {
        return this.columnNameToAliasMap;
    }

    public ObjList<QueryColumn> getColumns() {
        return this.columns;
    }

    public ExpressionNode getConstWhereClause() {
        return this.constWhereClause;
    }

    public void setConstWhereClause(ExpressionNode constWhereClause) {
        this.constWhereClause = constWhereClause;
    }

    public JoinContext getContext() {
        return this.context;
    }

    public void setContext(JoinContext context) {
        this.context = context;
    }

    public IntHashSet getDependencies() {
        return this.dependencies;
    }

    public ObjList<ExpressionNode> getExpressionModels() {
        return this.expressionModels;
    }

    public ObjList<ExpressionNode> getJoinColumns() {
        return this.joinColumns;
    }

    public ExpressionNode getJoinCriteria() {
        return this.joinCriteria;
    }

    public void setJoinCriteria(ExpressionNode joinCriteria) {
        this.joinCriteria = joinCriteria;
    }

    public int getJoinKeywordPosition() {
        return this.joinKeywordPosition;
    }

    public void setJoinKeywordPosition(int position) {
        this.joinKeywordPosition = position;
    }

    public ObjList<QueryModel> getJoinModels() {
        return this.joinModels;
    }

    public int getJoinType() {
        return this.joinType;
    }

    public void setJoinType(int joinType) {
        this.joinType = joinType;
    }

    public ObjList<ExpressionNode> getLatestBy() {
        return this.latestBy;
    }

    public ExpressionNode getLimitHi() {
        return this.limitHi;
    }

    public ExpressionNode getLimitLo() {
        return this.limitLo;
    }

    public int getModelPosition() {
        return this.modelPosition;
    }

    public void setModelPosition(int modelPosition) {
        this.modelPosition = modelPosition;
    }

    @Override
    public int getModelType() {
        return 1;
    }

    public CharSequence getName() {
        if (this.alias != null) {
            return this.alias.token;
        }
        if (this.tableName != null) {
            return this.tableName.token;
        }
        return null;
    }

    public QueryModel getNestedModel() {
        return this.nestedModel;
    }

    public void setNestedModel(QueryModel nestedModel) {
        this.nestedModel = nestedModel;
    }

    public ObjList<ExpressionNode> getOrderBy() {
        return this.orderBy;
    }

    public ObjList<ExpressionNode> getOrderByAdvice() {
        return this.orderByAdvice;
    }

    public int getOrderByAdviceMnemonic() {
        return this.orderByAdviceMnemonic;
    }

    public void setOrderByAdviceMnemonic(int orderByAdviceMnemonic) {
        this.orderByAdviceMnemonic = orderByAdviceMnemonic;
    }

    public IntList getOrderByDirection() {
        return this.orderByDirection;
    }

    public IntList getOrderByDirectionAdvice() {
        return this.orderByDirectionAdvice;
    }

    public CharSequenceIntHashMap getOrderHash() {
        return this.orderHash;
    }

    public IntList getOrderedJoinModels() {
        return this.orderedJoinModels;
    }

    public void setOrderedJoinModels(IntList that) {
        assert (that == this.orderedJoinModels1 || that == this.orderedJoinModels2);
        this.orderedJoinModels = that;
    }

    public ObjList<ExpressionNode> getParsedWhere() {
        return this.parsedWhere;
    }

    public ExpressionNode getPostJoinWhereClause() {
        return this.postJoinWhereClause;
    }

    public void setPostJoinWhereClause(ExpressionNode postJoinWhereClause) {
        this.postJoinWhereClause = postJoinWhereClause;
    }

    public ExpressionNode getSampleBy() {
        return this.sampleBy;
    }

    public void setSampleBy(ExpressionNode sampleBy) {
        this.sampleBy = sampleBy;
    }

    public ObjList<ExpressionNode> getSampleByFill() {
        return this.sampleByFill;
    }

    public int getSelectModelType() {
        return this.selectModelType;
    }

    public void setSelectModelType(int selectModelType) {
        this.selectModelType = selectModelType;
    }

    public ExpressionNode getTableName() {
        return this.tableName;
    }

    public void setTableName(ExpressionNode tableName) {
        this.tableName = tableName;
    }

    public Function getTableNameFunction() {
        return this.tableNameFunction;
    }

    public void setTableNameFunction(Function function) {
        this.tableNameFunction = function;
    }

    public long getTableVersion() {
        return this.tableVersion;
    }

    public void setTableVersion(long tableVersion) {
        this.tableVersion = tableVersion;
    }

    public ExpressionNode getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(ExpressionNode timestamp) {
        this.timestamp = timestamp;
    }

    public ObjList<QueryColumn> getTopDownColumns() {
        return this.topDownColumns;
    }

    public QueryModel getUnionModel() {
        return this.unionModel;
    }

    public void setUnionModel(QueryModel unionModel) {
        this.unionModel = unionModel;
    }

    public int getUnionModelType() {
        return this.unionModelType;
    }

    public void setUnionModelType(int unionModelType) {
        this.unionModelType = unionModelType;
    }

    public ExpressionNode getWhereClause() {
        return this.whereClause;
    }

    public void setWhereClause(ExpressionNode whereClause) {
        this.whereClause = whereClause;
    }

    public WithClauseModel getWithClause(CharSequence name) {
        return this.withClauses.get(name);
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isNestedModelIsSubQuery() {
        return this.nestedModelIsSubQuery;
    }

    public void setNestedModelIsSubQuery(boolean nestedModelIsSubQuery) {
        this.nestedModelIsSubQuery = nestedModelIsSubQuery;
    }

    public boolean isTopDownNameMissing(CharSequence columnName) {
        return this.topDownNameSet.excludes(columnName);
    }

    public void moveLimitFrom(QueryModel baseModel) {
        this.limitLo = baseModel.getLimitLo();
        this.limitHi = baseModel.getLimitHi();
        baseModel.setLimit(null, null);
    }

    public void moveSampleByFrom(QueryModel model) {
        this.sampleBy = model.sampleBy;
        this.sampleByFill.clear();
        this.sampleByFill.addAll(model.sampleByFill);
        model.clearSampleBy();
    }

    public IntList nextOrderedJoinModels() {
        IntList ordered = this.orderedJoinModels == this.orderedJoinModels1 ? this.orderedJoinModels2 : this.orderedJoinModels1;
        ordered.clear();
        return ordered;
    }

    public ObjList<ExpressionNode> parseWhereClause() {
        ExpressionNode n = this.getWhereClause();
        this.sqlNodeStack.clear();
        while (!this.sqlNodeStack.isEmpty() || n != null) {
            if (n != null) {
                if (Chars.equalsLowerCaseAscii(n.token, "and")) {
                    if (n.rhs != null) {
                        this.sqlNodeStack.push(n.rhs);
                    }
                    n = n.lhs;
                    continue;
                }
                this.addParsedWhereNode(n);
                n = null;
                continue;
            }
            n = this.sqlNodeStack.poll();
        }
        return this.getParsedWhere();
    }

    public void removeDependency(int index) {
        this.dependencies.remove(index);
    }

    public void replaceJoinModel(int pos, QueryModel model) {
        this.joinModels.setQuick(pos, model);
    }

    public void setLimit(ExpressionNode lo, ExpressionNode hi) {
        this.limitLo = lo;
        this.limitHi = hi;
    }

    @Override
    public void toSink(CharSink sink) {
        this.toSink0(sink, false);
    }

    @Override
    public CharSequence translateAlias(CharSequence column) {
        return this.aliasToColumnNameMap.get(column);
    }

    private static void aliasToSink(CharSequence alias, CharSink sink) {
        boolean quote;
        sink.put(' ');
        boolean bl = quote = Chars.indexOf(alias, ' ') != -1;
        if (quote) {
            sink.put('\'').put(alias).put('\'');
        } else {
            sink.put(alias);
        }
    }

    private String getSelectModelTypeText() {
        return modelTypeName.get(this.selectModelType);
    }

    private void sinkColumns(CharSink sink, ObjList<QueryColumn> columns) {
        int n = columns.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                sink.put(", ");
            }
            QueryColumn column = columns.getQuick(i);
            CharSequence name = column.getName();
            CharSequence alias = column.getAlias();
            ExpressionNode ast = column.getAst();
            if (column instanceof AnalyticColumn || name == null) {
                ObjList<ExpressionNode> orderBy;
                ast.toSink(sink);
                if (alias != null) {
                    QueryModel.aliasToSink(alias, sink);
                }
                if (name == null) continue;
                AnalyticColumn ac = (AnalyticColumn)column;
                sink.put(" over (");
                ObjList<ExpressionNode> partitionBy = ac.getPartitionBy();
                if (partitionBy.size() > 0) {
                    sink.put("partition by ");
                    int z = partitionBy.size();
                    for (int k = 0; k < z; ++k) {
                        if (k > 0) {
                            sink.put(", ");
                        }
                        partitionBy.getQuick(k).toSink(sink);
                    }
                }
                if ((orderBy = ac.getOrderBy()).size() > 0) {
                    if (partitionBy.size() > 0) {
                        sink.put(' ');
                    }
                    sink.put("order by ");
                    int z = orderBy.size();
                    for (int k = 0; k < z; ++k) {
                        if (k > 0) {
                            sink.put(", ");
                        }
                        orderBy.getQuick(k).toSink(sink);
                        if (ac.getOrderByDirection().getQuick(k) != 1) continue;
                        sink.put(" desc");
                    }
                }
                sink.put(')');
                continue;
            }
            ast.toSink(sink);
            if (alias == null || ast.type == 4 && ast.token.equals(alias)) continue;
            QueryModel.aliasToSink(alias, sink);
        }
    }

    private void toSink0(CharSink sink, boolean joinSlave) {
        int i;
        int i2;
        int n;
        boolean hasColumns;
        boolean bl = hasColumns = this.topDownColumns.size() > 0 || this.columns.size() > 0;
        if (hasColumns) {
            sink.put(this.getSelectModelTypeText());
            if (this.topDownColumns.size() > 0) {
                sink.put(' ');
                sink.put('[');
                this.sinkColumns(sink, this.topDownColumns);
                sink.put(']');
            }
            if (this.columns.size() > 0) {
                sink.put(' ');
                this.sinkColumns(sink, this.columns);
            }
            sink.put(" from ");
        }
        if (this.tableName != null) {
            this.tableName.toSink(sink);
        } else {
            sink.put('(');
            this.nestedModel.toSink(sink);
            sink.put(')');
        }
        if (this.alias != null) {
            QueryModel.aliasToSink(this.alias.token, sink);
        }
        if (this.timestamp != null) {
            sink.put(" timestamp (");
            this.timestamp.toSink(sink);
            sink.put(')');
        }
        if (this.getLatestBy().size() > 0) {
            sink.put(" latest by ");
            n = this.getLatestBy().size();
            for (i2 = 0; i2 < n; ++i2) {
                this.getLatestBy().getQuick(i2).toSink(sink);
            }
        }
        if (this.orderedJoinModels.size() > 1) {
            n = this.orderedJoinModels.size();
            for (i2 = 0; i2 < n; ++i2) {
                QueryModel model = this.joinModels.getQuick(this.orderedJoinModels.getQuick(i2));
                if (model == this) continue;
                switch (model.getJoinType()) {
                    case 2: {
                        sink.put(" outer join ");
                        break;
                    }
                    case 4: {
                        sink.put(" asof join ");
                        break;
                    }
                    case 5: {
                        sink.put(" splice join ");
                        break;
                    }
                    case 3: {
                        sink.put(" cross join ");
                        break;
                    }
                    default: {
                        sink.put(" join ");
                    }
                }
                if (model.getWhereClause() != null) {
                    sink.put('(');
                    model.toSink0(sink, true);
                    sink.put(')');
                    if (model.getAlias() != null) {
                        QueryModel.aliasToSink(model.getAlias().token, sink);
                    } else if (model.getTableName() != null) {
                        QueryModel.aliasToSink(model.getTableName().token, sink);
                    }
                } else {
                    model.toSink0(sink, true);
                }
                JoinContext jc = model.getContext();
                if (jc != null && jc.aIndexes.size() > 0) {
                    sink.put(" on ");
                    int z = jc.aIndexes.size();
                    for (int k = 0; k < z; ++k) {
                        if (k > 0) {
                            sink.put(" and ");
                        }
                        jc.aNodes.getQuick(k).toSink(sink);
                        sink.put(" = ");
                        jc.bNodes.getQuick(k).toSink(sink);
                    }
                }
                if (model.getPostJoinWhereClause() == null) continue;
                sink.put(" post-join-where ");
                model.getPostJoinWhereClause().toSink(sink);
            }
        }
        if (this.whereClause != null) {
            sink.put(" where ");
            this.whereClause.toSink(sink);
        }
        if (this.constWhereClause != null) {
            sink.put(" const-where ");
            this.constWhereClause.toSink(sink);
        }
        if (!joinSlave && this.postJoinWhereClause != null) {
            sink.put(" post-join-where ");
            this.postJoinWhereClause.toSink(sink);
        }
        if (this.sampleBy != null) {
            sink.put(" sample by ");
            this.sampleBy.toSink(sink);
            int fillCount = this.sampleByFill.size();
            if (fillCount > 0) {
                sink.put(" fill(");
                sink.put(this.sampleByFill.getQuick(0));
                if (fillCount > 1) {
                    for (i = 1; i < fillCount; ++i) {
                        sink.put(',');
                        sink.put(this.sampleByFill.getQuick(i));
                    }
                }
                sink.put(')');
            }
        }
        if (this.orderHash.size() > 0 && this.orderBy.size() > 0) {
            sink.put(" order by ");
            ObjList<CharSequence> columnNames = this.orderHash.keys();
            int n2 = columnNames.size();
            for (i = 0; i < n2; ++i) {
                if (i > 0) {
                    sink.put(", ");
                }
                CharSequence key = columnNames.getQuick(i);
                sink.put(key);
                if (this.orderHash.get(key) != 1) continue;
                sink.put(" desc");
            }
        }
        if (this.getLimitLo() != null || this.getLimitHi() != null) {
            sink.put(" limit ");
            if (this.getLimitLo() != null) {
                this.getLimitLo().toSink(sink);
            }
            if (this.getLimitHi() != null) {
                sink.put(',');
                this.getLimitHi().toSink(sink);
            }
        }
        if (this.unionModel != null) {
            sink.put(" union ");
            if (this.unionModelType == 0) {
                sink.put("all ");
            }
            this.unionModel.toSink0(sink, false);
        }
    }

    static {
        modelTypeName.extendAndSet(0, "select");
        modelTypeName.extendAndSet(1, "select-choose");
        modelTypeName.extendAndSet(2, "select-virtual");
        modelTypeName.extendAndSet(3, "select-analytic");
        modelTypeName.extendAndSet(4, "select-group-by");
        modelTypeName.extendAndSet(5, "select-distinct");
    }

    public static final class QueryModelFactory
    implements ObjectFactory<QueryModel> {
        @Override
        public QueryModel newInstance() {
            return new QueryModel();
        }
    }
}

