/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.LogError;
import io.questdb.log.LogRecordSink;
import io.questdb.log.LogWriter;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Chars;
import io.questdb.std.Files;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.Unsafe;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class LogFileWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    private static final int DEFAULT_BUFFER_SIZE = 0x100000;
    private final RingQueue<LogRecordSink> ring;
    private final SCSequence subSeq;
    private final int level;
    private long fd = -1L;
    private long lim;
    private long buf;
    private long _wptr;
    private final QueueConsumer<LogRecordSink> myConsumer = this::copyToBuffer;
    private String location;
    private String truncate;
    private String bufferSize;
    private int bufSize;

    public LogFileWriter(RingQueue<LogRecordSink> ring, SCSequence subSeq, int level) {
        this.ring = ring;
        this.subSeq = subSeq;
        this.level = level;
    }

    @Override
    public void bindProperties() {
        if (this.bufferSize != null) {
            try {
                this.bufSize = Numbers.parseIntSize(this.bufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for bufferSize");
            }
        } else {
            this.bufSize = 0x100000;
        }
        this.buf = this._wptr = Unsafe.malloc(this.bufSize);
        this.lim = this.buf + (long)this.bufSize;
        try (Path path = new Path().of(this.location).$();){
            if (this.truncate != null && Chars.equalsLowerCaseAscii(this.truncate, "true")) {
                this.fd = Files.openRW(path);
                Files.truncate(this.fd, 0L);
            } else {
                this.fd = Files.openAppend(path);
            }
        }
        if (this.fd == -1L) {
            throw new LogError("Cannot open file for append: " + this.location);
        }
    }

    @Override
    public void close() {
        if (this.buf != 0L) {
            if (this._wptr > this.buf) {
                this.flush();
            }
            Unsafe.free(this.buf, this.bufSize);
            this.buf = 0L;
        }
        if (this.fd != -1L) {
            Files.close(this.fd);
            this.fd = -1L;
        }
    }

    public int getBufSize() {
        return this.bufSize;
    }

    @Override
    public boolean runSerially() {
        if (this.subSeq.consumeAll(this.ring, this.myConsumer)) {
            return true;
        }
        if (this._wptr > this.buf) {
            this.flush();
            return true;
        }
        return false;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    private void copyToBuffer(LogRecordSink sink) {
        if ((sink.getLevel() & this.level) != 0) {
            int l = sink.length();
            if (this._wptr + (long)l >= this.lim) {
                this.flush();
            }
            Unsafe.getUnsafe().copyMemory(sink.getAddress(), this._wptr, l);
            this._wptr += (long)l;
        }
    }

    private void flush() {
        Files.append(this.fd, this.buf, (int)(this._wptr - this.buf));
        this._wptr = this.buf;
    }
}

