/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.LogError;
import io.questdb.log.LogRecordSink;
import io.questdb.log.LogWriter;
import io.questdb.mp.QueueConsumer;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SCSequence;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.Chars;
import io.questdb.std.FilesFacade;
import io.questdb.std.FilesFacadeImpl;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.Sinkable;
import io.questdb.std.Unsafe;
import io.questdb.std.microtime.DateFormatCompiler;
import io.questdb.std.microtime.MicrosecondClock;
import io.questdb.std.microtime.MicrosecondClockImpl;
import io.questdb.std.microtime.TimestampFormat;
import io.questdb.std.microtime.TimestampLocaleFactory;
import io.questdb.std.microtime.Timestamps;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import java.io.Closeable;

public class LogRollingFileWriter
extends SynchronizedJob
implements Closeable,
LogWriter {
    public static final long DEFAULT_SPIN_BEFORE_FLUSH = 100000L;
    private static final int DEFAULT_BUFFER_SIZE = 0x400000;
    private final DateFormatCompiler compiler = new DateFormatCompiler();
    private final RingQueue<LogRecordSink> ring;
    private final SCSequence subSeq;
    private final int level;
    private final Path path = new Path();
    private final Path renameToPath = new Path();
    private final FilesFacade ff;
    private final MicrosecondClock clock;
    private final ObjList<Sinkable> locationComponents = new ObjList();
    private long fd = -1L;
    private long lim;
    private long buf;
    private long _wptr;
    private int nBufferSize;
    private long nRollSize;
    private String location;
    private long fileTimestamp = 0L;
    private String bufferSize;
    private String rollSize;
    private String spinBeforeFlush;
    private long nSpinBeforeFlush;
    private long currentSize;
    private String rollEvery;
    private long idleSpinCount = 0L;
    private long rollDeadline;
    private NextDeadline rollDeadlineFunction;
    private final QueueConsumer<LogRecordSink> myConsumer = this::copyToBuffer;

    public LogRollingFileWriter(RingQueue<LogRecordSink> ring, SCSequence subSeq, int level) {
        this(FilesFacadeImpl.INSTANCE, MicrosecondClockImpl.INSTANCE, ring, subSeq, level);
    }

    public LogRollingFileWriter(FilesFacade ff, MicrosecondClock clock, RingQueue<LogRecordSink> ring, SCSequence subSeq, int level) {
        this.ff = ff;
        this.clock = clock;
        this.ring = ring;
        this.subSeq = subSeq;
        this.level = level;
    }

    @Override
    public void bindProperties() {
        this.parseLocation();
        if (this.bufferSize != null) {
            try {
                this.nBufferSize = Numbers.parseIntSize(this.bufferSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for bufferSize");
            }
        } else {
            this.nBufferSize = 0x400000;
        }
        if (this.rollSize != null) {
            try {
                this.nRollSize = Numbers.parseLongSize(this.rollSize);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for rollSize");
            }
        } else {
            this.nRollSize = Long.MAX_VALUE;
        }
        if (this.spinBeforeFlush != null) {
            try {
                this.nSpinBeforeFlush = Numbers.parseLong(this.spinBeforeFlush);
            }
            catch (NumericException e) {
                throw new LogError("Invalid value for spinBeforeFlush");
            }
        } else {
            this.nSpinBeforeFlush = 100000L;
        }
        if (this.rollEvery != null) {
            switch (this.rollEvery.toUpperCase()) {
                case "DAY": {
                    this.rollDeadlineFunction = this::getNextDayDealine;
                    break;
                }
                case "MONTH": {
                    this.rollDeadlineFunction = this::getNextMonthDeadline;
                    break;
                }
                case "YEAR": {
                    this.rollDeadlineFunction = this::getNextYearDeadline;
                    break;
                }
                case "HOUR": {
                    this.rollDeadlineFunction = this::getNextHourDeadline;
                    break;
                }
                case "MINUTE": {
                    this.rollDeadlineFunction = this::getNextMinuteDeadline;
                    break;
                }
                default: {
                    this.rollDeadlineFunction = this::getInfiniteDeadline;
                    break;
                }
            }
        } else {
            this.rollDeadlineFunction = this::getInfiniteDeadline;
        }
        this.rollDeadline = this.rollDeadlineFunction.getDeadline();
        this.buf = this._wptr = Unsafe.malloc(this.nBufferSize);
        this.lim = this.buf + (long)this.nBufferSize;
        this.fileTimestamp = this.clock.getTicks();
        this.openFile();
    }

    @Override
    public void close() {
        if (this.buf != 0L) {
            if (this._wptr > this.buf) {
                this.flush();
            }
            Unsafe.free(this.buf, this.nBufferSize);
            this.buf = 0L;
        }
        if (this.fd != -1L) {
            this.ff.close(this.fd);
            this.fd = -1L;
        }
        Misc.free(this.path);
        Misc.free(this.renameToPath);
    }

    @Override
    public boolean runSerially() {
        if (this.subSeq.consumeAll(this.ring, this.myConsumer)) {
            return true;
        }
        if (++this.idleSpinCount > this.nSpinBeforeFlush && this._wptr > this.buf) {
            this.flush();
            this.idleSpinCount = 0L;
            return true;
        }
        return false;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setRollEvery(String rollEvery) {
        this.rollEvery = rollEvery;
    }

    public void setRollSize(String rollSize) {
        this.rollSize = rollSize;
    }

    public void setSpinBeforeFlush(String spinBeforeFlush) {
        this.spinBeforeFlush = spinBeforeFlush;
    }

    private void buildFilePath(Path path) {
        path.of("");
        int n = this.locationComponents.size();
        for (int i = 0; i < n; ++i) {
            this.locationComponents.getQuick(i).toSink(path);
        }
    }

    private void buildUniquePath() {
        this.buildFilePath(this.path);
        while (this.ff.exists(this.path.$())) {
            this.pushFileStackUp();
            this.buildFilePath(this.path);
        }
    }

    private void copyToBuffer(LogRecordSink sink) {
        if ((sink.getLevel() & this.level) != 0) {
            int l = sink.length();
            if (this._wptr + (long)l >= this.lim) {
                this.flush();
            }
            Unsafe.getUnsafe().copyMemory(sink.getAddress(), this._wptr, l);
            this._wptr += (long)l;
        }
    }

    private void flush() {
        int len;
        long ticks = Long.MIN_VALUE;
        if (this.currentSize > this.nRollSize || (ticks = this.clock.getTicks()) > this.rollDeadline) {
            this.ff.close(this.fd);
            if (ticks > this.rollDeadline) {
                this.rollDeadline = this.rollDeadlineFunction.getDeadline();
                this.fileTimestamp = ticks;
            }
            this.openFile();
        }
        if (this.ff.append(this.fd, this.buf, len = (int)(this._wptr - this.buf)) != (long)len) {
            throw new LogError("Could not append log [fd=" + this.fd + "]");
        }
        this.currentSize += (long)len;
        this._wptr = this.buf;
    }

    private long getInfiniteDeadline() {
        return Long.MAX_VALUE;
    }

    private long getNextDayDealine() {
        return Timestamps.addDays(Timestamps.floorDD(this.clock.getTicks()), 1);
    }

    private long getNextHourDeadline() {
        return Timestamps.addHours(Timestamps.floorHH(this.clock.getTicks()), 1);
    }

    private long getNextMinuteDeadline() {
        return Timestamps.floorMI(this.clock.getTicks()) + 60000000L;
    }

    private long getNextMonthDeadline() {
        return Timestamps.addMonths(Timestamps.floorMM(this.clock.getTicks()), 1);
    }

    private long getNextYearDeadline() {
        return Timestamps.addYear(Timestamps.floorYYYY(this.clock.getTicks()), 1);
    }

    private void openFile() {
        this.buildUniquePath();
        this.fd = this.ff.openAppend(this.path.$());
        if (this.fd == -1L) {
            throw new LogError("[" + this.ff.errno() + "] Cannot open file for append: " + this.path);
        }
        this.currentSize = this.ff.length(this.fd);
    }

    private void parseLocation() {
        this.locationComponents.clear();
        int start = 0;
        boolean dollar = false;
        boolean open = false;
        int n = this.location.length();
        block5: for (int i = 0; i < n; ++i) {
            char c = this.location.charAt(i);
            switch (c) {
                case '$': {
                    if (dollar) {
                        this.locationComponents.add(new SubStrSinkable(i, i + 1));
                        start = i;
                        continue block5;
                    }
                    this.locationComponents.add(new SubStrSinkable(start, i));
                    start = i;
                    dollar = true;
                    continue block5;
                }
                case '{': {
                    if (!dollar) continue block5;
                    if (open) {
                        throw new LogError("could not parse location");
                    }
                    open = true;
                    start = i + 1;
                    continue block5;
                }
                case '}': {
                    if (!dollar) continue block5;
                    if (open) {
                        open = false;
                        dollar = false;
                        if (!Chars.startsWith(this.location, start, i - 1, "date:")) {
                            throw new LogError("unknown variable at " + start);
                        }
                        this.locationComponents.add(new DateSinkable(this.compiler.compile(this.location, start + 5, i, false)));
                        start = i + 1;
                        continue block5;
                    }
                    throw new LogError("could not parse location");
                }
            }
        }
        if (start < this.location.length()) {
            this.locationComponents.add(new SubStrSinkable(start, this.location.length()));
        }
    }

    private void pushFileStackUp() {
        int index = 1;
        while (true) {
            this.buildFilePath(this.path);
            this.path.put('.').put(index);
            if (!this.ff.exists(this.path.$())) break;
            ++index;
        }
        while (index > 1) {
            this.buildFilePath(this.path);
            this.buildFilePath(this.renameToPath);
            this.path.put('.').put(index - 1);
            this.renameToPath.put('.').put(index);
            if (!this.ff.rename(this.path.$(), this.renameToPath.$())) {
                throw new LogError("Could not rename " + this.path + " to " + this.renameToPath);
            }
            --index;
        }
        this.buildFilePath(this.path);
        this.buildFilePath(this.renameToPath);
        this.renameToPath.put(".1");
        if (!this.ff.rename(this.path.$(), this.renameToPath.$())) {
            throw new LogError("Could not rename " + this.path + " to " + this.renameToPath);
        }
    }

    private class DateSinkable
    implements Sinkable {
        private final TimestampFormat format;

        public DateSinkable(TimestampFormat format) {
            this.format = format;
        }

        @Override
        public void toSink(CharSink sink) {
            this.format.format(LogRollingFileWriter.this.fileTimestamp, TimestampLocaleFactory.INSTANCE.getDefaultTimestampLocale(), null, sink);
        }
    }

    private class SubStrSinkable
    implements Sinkable {
        private final int start;
        private final int end;

        public SubStrSinkable(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Override
        public void toSink(CharSink sink) {
            sink.put(LogRollingFileWriter.this.location, this.start, this.end);
        }
    }

    @FunctionalInterface
    private static interface NextDeadline {
        public long getDeadline();
    }
}

