/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.log;

import io.questdb.log.Log;
import io.questdb.log.LogRecord;
import io.questdb.log.LogRecordSink;
import io.questdb.log.NullLogRecord;
import io.questdb.mp.RingQueue;
import io.questdb.mp.Sequence;
import io.questdb.network.Net;
import io.questdb.std.Sinkable;
import io.questdb.std.microtime.MicrosecondClock;
import io.questdb.std.str.CharSink;
import java.io.File;

class Logger
implements LogRecord,
Log {
    private final CharSequence name;
    private final RingQueue<LogRecordSink> debugRing;
    private final Sequence debugSeq;
    private final RingQueue<LogRecordSink> infoRing;
    private final Sequence infoSeq;
    private final RingQueue<LogRecordSink> errorRing;
    private final Sequence errorSeq;
    private final ThreadLocalCursor tl = new ThreadLocalCursor();
    private final MicrosecondClock clock;

    Logger(MicrosecondClock clock, CharSequence name, RingQueue<LogRecordSink> debugRing, Sequence debugSeq, RingQueue<LogRecordSink> infoRing, Sequence infoSeq, RingQueue<LogRecordSink> errorRing, Sequence errorSeq) {
        this.clock = clock;
        this.name = name;
        this.debugRing = debugRing;
        this.debugSeq = debugSeq;
        this.infoRing = infoRing;
        this.infoSeq = infoSeq;
        this.errorRing = errorRing;
        this.errorSeq = errorSeq;
    }

    @Override
    public void $() {
        this.$("\r\n");
        Holder h = (Holder)this.tl.get();
        h.seq.done(h.cursor);
    }

    @Override
    public LogRecord $(CharSequence sequence) {
        if (sequence == null) {
            this.sink().put("null");
        } else {
            this.sink().put(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $(CharSequence sequence, int lo, int hi) {
        this.sink().put(sequence, lo, hi);
        return this;
    }

    @Override
    public LogRecord utf8(CharSequence sequence) {
        if (sequence == null) {
            this.sink().put("null");
        } else {
            this.sink().encodeUtf8(sequence);
        }
        return this;
    }

    @Override
    public LogRecord $(int x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(double x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(long x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(char c) {
        this.sink().put(c);
        return this;
    }

    @Override
    public LogRecord $(boolean x) {
        this.sink().put(x);
        return this;
    }

    @Override
    public LogRecord $(Throwable e) {
        if (e != null) {
            this.sink().put("\r\n").put(e);
        }
        return this;
    }

    @Override
    public LogRecord $(File x) {
        this.sink().put(x == null ? "null" : x.getAbsolutePath());
        return this;
    }

    @Override
    public LogRecord $(Object x) {
        this.sink().put(x == null ? "null" : x.toString());
        return this;
    }

    @Override
    public LogRecord $(Sinkable x) {
        if (x == null) {
            this.sink().put("null");
        } else {
            x.toSink(this.sink());
        }
        return this;
    }

    @Override
    public LogRecord $ip(long ip) {
        Net.appendIP4(this.sink(), ip);
        return this;
    }

    @Override
    public LogRecord $ts(long x) {
        this.sink().putISODate(x);
        return this;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public LogRecord ts() {
        this.sink().putISODate(this.clock.getTicks());
        return this;
    }

    @Override
    public LogRecord debug() {
        return this.xdebug().ts().$(" D ").$(this.name);
    }

    @Override
    public LogRecord error() {
        return this.xerror().ts().$(" E ").$(this.name);
    }

    @Override
    public LogRecord info() {
        return this.xinfo().ts().$(" I ").$(this.name);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.debugSeq != null;
    }

    @Override
    public LogRecord xerror() {
        return this.next(this.errorSeq, this.errorRing, 4);
    }

    @Override
    public LogRecord xinfo() {
        return this.next(this.infoSeq, this.infoRing, 2);
    }

    private LogRecord next(Sequence seq, RingQueue<LogRecordSink> ring, int level) {
        if (seq == null) {
            return NullLogRecord.INSTANCE;
        }
        long cursor = seq.next();
        if (cursor < 0L) {
            return NullLogRecord.INSTANCE;
        }
        Holder h = (Holder)this.tl.get();
        h.cursor = cursor;
        h.seq = seq;
        h.ring = ring;
        LogRecordSink r = ring.get(cursor);
        r.setLevel(level);
        r.clear(0);
        return this;
    }

    private CharSink sink() {
        Holder h = (Holder)this.tl.get();
        return (CharSink)h.ring.get(h.cursor);
    }

    private LogRecord xdebug() {
        return this.next(this.debugSeq, this.debugRing, 1);
    }

    private static class ThreadLocalCursor
    extends ThreadLocal<Holder> {
        private ThreadLocalCursor() {
        }

        @Override
        protected Holder initialValue() {
            return new Holder();
        }
    }

    private static class Holder {
        private long cursor;
        private Sequence seq;
        private RingQueue<LogRecordSink> ring;

        private Holder() {
        }
    }
}

