/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.AbstractSequence;
import io.questdb.mp.Barrier;
import io.questdb.mp.NullWaitStrategy;
import io.questdb.mp.OpenBarrier;
import io.questdb.mp.Sequence;
import io.questdb.mp.WaitStrategy;

abstract class AbstractSSequence
extends AbstractSequence
implements Sequence {
    AbstractSSequence(WaitStrategy waitStrategy) {
        super(waitStrategy);
    }

    AbstractSSequence() {
        this(NullWaitStrategy.INSTANCE);
    }

    @Override
    public long nextBully() {
        long cursor;
        while ((cursor = this.next()) < 0L) {
            this.bully();
        }
        return cursor;
    }

    @Override
    public long waitForNext() {
        long r;
        WaitStrategy waitStrategy = this.getWaitStrategy();
        while ((r = this.next()) < 0L) {
            waitStrategy.await();
        }
        return r;
    }

    @Override
    public Barrier root() {
        return this.barrier != OpenBarrier.INSTANCE ? this.barrier.root() : this;
    }

    @Override
    public void setBarrier(Barrier barrier) {
        this.barrier = barrier;
    }

    @Override
    public Barrier then(Barrier barrier) {
        barrier.setBarrier(this);
        return barrier;
    }

    private void bully() {
        this.barrier.getWaitStrategy().signal();
    }
}

