/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.AbstractWaitStrategy;
import io.questdb.mp.AlertedException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BlockingWaitStrategy
extends AbstractWaitStrategy {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();

    @Override
    public boolean acceptSignal() {
        return true;
    }

    @Override
    public void await() {
        this.lock.lock();
        try {
            if (this.alerted) {
                throw AlertedException.INSTANCE;
            }
            this.condition.awaitUninterruptibly();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void signal() {
        this.lock.lock();
        try {
            this.condition.signalAll();
        }
        finally {
            this.lock.unlock();
        }
    }
}

