/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.Barrier;
import io.questdb.mp.NullWaitStrategy;
import io.questdb.mp.WaitStrategy;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;

public class FanOut
implements Barrier {
    private static final long HOLDER = Unsafe.getFieldOffset(FanOut.class, "holder");
    private final Holder holder;
    private Barrier barrier;

    public FanOut(Barrier ... barriers) {
        Holder h = new Holder();
        for (int i = 0; i < barriers.length; ++i) {
            Barrier sq = barriers[i];
            h.barriers.add(sq);
            if (!sq.getWaitStrategy().acceptSignal()) continue;
            h.waitStrategies.add(sq.getWaitStrategy());
        }
        h.setupWaitStrategy();
        this.holder = h;
    }

    public static FanOut to(Barrier barrier) {
        return new FanOut(new Barrier[0]).and(barrier);
    }

    public <T extends Barrier> T addAndGet(T sequence) {
        this.and(sequence);
        return sequence;
    }

    public FanOut and(Barrier barrier) {
        Holder _new;
        do {
            Holder h;
            if ((h = this.holder).barriers.indexOf(barrier) > -1) {
                return this;
            }
            if (this.barrier != null) {
                barrier.root().setBarrier(this.barrier);
            }
            _new = new Holder();
            _new.barriers.addAll(h.barriers);
            _new.barriers.add(barrier);
            _new.waitStrategies.addAll(h.waitStrategies);
            if (barrier.getWaitStrategy().acceptSignal()) {
                _new.waitStrategies.add(barrier.getWaitStrategy());
            }
            _new.setupWaitStrategy();
        } while (!Unsafe.getUnsafe().compareAndSwapObject(this, HOLDER, this.holder, _new));
        return this;
    }

    @Override
    public long availableIndex(long lo) {
        long l = Long.MAX_VALUE;
        ObjList sequences = this.holder.barriers;
        int n = sequences.size();
        for (int i = 0; i < n; ++i) {
            l = Math.min(l, ((Barrier)sequences.getQuick(i)).availableIndex(lo));
        }
        return l;
    }

    @Override
    public WaitStrategy getWaitStrategy() {
        return this.holder.waitStrategy;
    }

    @Override
    public Barrier root() {
        return this.barrier != null ? this.barrier.root() : this;
    }

    @Override
    public void setBarrier(Barrier barrier) {
        this.barrier = barrier;
        ObjList barriers = this.holder.barriers;
        int n = barriers.size();
        for (int i = 0; i < n; ++i) {
            ((Barrier)barriers.getQuick(i)).root().setBarrier(barrier);
        }
    }

    @Override
    public Barrier then(Barrier barrier) {
        barrier.setBarrier(this);
        return barrier;
    }

    public void remove(Barrier barrier) {
        Holder _new;
        do {
            Holder h;
            if ((h = this.holder).barriers.indexOf(barrier) == -1) {
                return;
            }
            _new = new Holder();
            int n = h.barriers.size();
            for (int i = 0; i < n; ++i) {
                Barrier sq = (Barrier)h.barriers.getQuick(i);
                if (sq == barrier) continue;
                _new.barriers.add(sq);
            }
            WaitStrategy that = barrier.getWaitStrategy();
            if (that.acceptSignal()) {
                int n2 = h.waitStrategies.size();
                for (int i = 0; i < n2; ++i) {
                    WaitStrategy ws = (WaitStrategy)h.waitStrategies.getQuick(i);
                    if (ws == that) continue;
                    _new.waitStrategies.add(ws);
                }
            } else {
                _new.waitStrategies.addAll(h.waitStrategies);
            }
            _new.setupWaitStrategy();
        } while (!Unsafe.getUnsafe().compareAndSwapObject(this, HOLDER, this.holder, _new));
    }

    private static class Holder {
        private final ObjList<Barrier> barriers = new ObjList();
        private final ObjList<WaitStrategy> waitStrategies = new ObjList();
        private final FanOutWaitStrategy fanOutWaitStrategy = new FanOutWaitStrategy();
        private WaitStrategy waitStrategy;

        private Holder() {
        }

        private void setupWaitStrategy() {
            this.waitStrategy = this.waitStrategies.size() > 0 ? this.fanOutWaitStrategy : NullWaitStrategy.INSTANCE;
        }

        private class FanOutWaitStrategy
        implements WaitStrategy {
            private FanOutWaitStrategy() {
            }

            @Override
            public boolean acceptSignal() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    if (!((WaitStrategy)Holder.this.waitStrategies.getQuick(i)).acceptSignal()) continue;
                    return true;
                }
                return false;
            }

            @Override
            public void alert() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    ((WaitStrategy)Holder.this.waitStrategies.getQuick(i)).alert();
                }
            }

            @Override
            public void await() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    ((WaitStrategy)Holder.this.waitStrategies.getQuick(i)).await();
                }
            }

            @Override
            public void signal() {
                int n = Holder.this.waitStrategies.size();
                for (int i = 0; i < n; ++i) {
                    ((WaitStrategy)Holder.this.waitStrategies.getQuick(i)).signal();
                }
            }
        }
    }
}

