/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.mp.AbstractMSequence;
import io.questdb.mp.NullWaitStrategy;
import io.questdb.mp.WaitStrategy;

public class MPSequence
extends AbstractMSequence {
    private final int cycle;

    public MPSequence(int cycle) {
        this(cycle, NullWaitStrategy.INSTANCE);
    }

    private MPSequence(int cycle, WaitStrategy waitStrategy) {
        super(cycle, waitStrategy);
        this.cycle = cycle;
    }

    @Override
    public long next() {
        long current = this.value;
        long next = current + 1L;
        long lo = next - (long)this.cycle;
        long cached = this.cache;
        if (lo > cached) {
            long avail = this.barrier.availableIndex(lo);
            if (avail > cached) {
                this.setCacheFenced(avail);
                if (lo > avail) {
                    return -1L;
                }
            } else {
                return -1L;
            }
        }
        return this.casValue(current, next) ? next : -2L;
    }
}

