/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.mp;

import io.questdb.log.Log;
import io.questdb.mp.EagerThreadSetup;
import io.questdb.mp.Job;
import io.questdb.mp.SOCountDownLatch;
import io.questdb.mp.WorkerCleaner;
import io.questdb.std.ObjHashSet;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class Worker
extends Thread {
    private static final long RUNNING_OFFSET = Unsafe.getFieldOffset(Worker.class, "running");
    private static final long YIELD_THRESHOLD = 10L;
    private static final long SLEEP_THRESHOLD = 10000L;
    private static final AtomicInteger COUNTER = new AtomicInteger();
    private final ObjHashSet<? extends Job> jobs;
    private final SOCountDownLatch haltLatch;
    private final int affinity;
    private final Log log;
    private final WorkerCleaner cleaner;
    private final boolean haltOnError;
    private volatile int running = 0;
    private volatile int fence;

    public Worker(ObjHashSet<? extends Job> jobs, SOCountDownLatch haltLatch) {
        this(jobs, haltLatch, -1, null, null, true);
    }

    public Worker(ObjHashSet<? extends Job> jobs, SOCountDownLatch haltLatch, int affinity, Log log, WorkerCleaner cleaner, boolean haltOnError) {
        this.log = log;
        this.jobs = jobs;
        this.haltLatch = haltLatch;
        this.setName("questdb-worker-" + COUNTER.incrementAndGet());
        this.affinity = affinity;
        this.cleaner = cleaner;
        this.haltOnError = haltOnError;
    }

    public void halt() {
        this.running = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable ex = null;
        try {
            if (Unsafe.getUnsafe().compareAndSwapInt(this, RUNNING_OFFSET, 0, 1)) {
                if (this.affinity > -1) {
                    if (Os.setCurrentThreadAffinity(this.affinity) == 0) {
                        if (this.log != null) {
                            this.log.info().$("affinity set [cpu=").$(this.affinity).$(", name=").$(this.getName()).$(']').$();
                        }
                    } else if (this.log != null) {
                        this.log.error().$("could not set affinity [cpu=").$(this.affinity).$(", name=").$(this.getName()).$(']').$();
                    }
                } else if (this.log != null) {
                    this.log.info().$("os scheduled [name=").$(this.getName()).$(']').$();
                }
                this.setupJobs();
                int n = this.jobs.size();
                long uselessCounter = 0L;
                while (this.running == 1) {
                    boolean useful = false;
                    for (int i = 0; i < n; ++i) {
                        this.loadFence();
                        try {
                            try {
                                useful |= this.jobs.get(i).run();
                            }
                            catch (Throwable e) {
                                if (this.haltOnError) {
                                    throw e;
                                }
                                if (this.log != null) {
                                    this.log.error().$("unhandled error [job=").$(this.jobs.get(i).toString()).$(", ex=").$(e).$(']').$();
                                    continue;
                                }
                                e.printStackTrace();
                            }
                            continue;
                        }
                        finally {
                            this.storeFence();
                        }
                    }
                    if (useful) {
                        uselessCounter = 0L;
                        continue;
                    }
                    if (++uselessCounter < 0L) {
                        uselessCounter = 10001L;
                    }
                    if (uselessCounter > 10L) {
                        Thread.yield();
                    }
                    if (uselessCounter <= 10000L) continue;
                    LockSupport.parkNanos(1000000L);
                }
            }
        }
        catch (Throwable e) {
            ex = e;
        }
        finally {
            if (this.cleaner != null) {
                this.cleaner.run(ex);
            }
            this.haltLatch.countDown();
        }
    }

    private int loadFence() {
        return this.fence;
    }

    private void setupJobs() {
        if (this.running == 1) {
            for (int i = 0; i < this.jobs.size(); ++i) {
                this.loadFence();
                try {
                    Job job = this.jobs.get(i);
                    if (!(job instanceof EagerThreadSetup)) continue;
                    ((EagerThreadSetup)((Object)job)).setup();
                    continue;
                }
                finally {
                    this.storeFence();
                }
            }
        }
    }

    private void storeFence() {
        this.fence = 1;
    }
}

