/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.network;

import io.questdb.network.Net;
import io.questdb.std.Sinkable;
import io.questdb.std.ThreadLocal;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.StringSink;

public class NetworkError
extends Error
implements Sinkable {
    private static final ThreadLocal<NetworkError> tlException = new ThreadLocal<NetworkError>(NetworkError::new);
    private final StringSink message = new StringSink();
    private int errno;

    public static NetworkError instance(int errno, CharSequence message) {
        NetworkError ex = (NetworkError)tlException.get();
        ex.errno = errno;
        ex.message.clear();
        ex.message.put(message);
        return ex;
    }

    public static NetworkError instance(int errno) {
        NetworkError ex = (NetworkError)tlException.get();
        ex.errno = errno;
        ex.message.clear();
        return ex;
    }

    public NetworkError couldNotBindSocket() {
        this.message.put("could not bind socket");
        return this;
    }

    @Override
    public String getMessage() {
        return "[" + this.errno + "] " + this.message.toString();
    }

    public NetworkError ip(int ipv4) {
        Net.appendIP4(this.message, ipv4);
        return this;
    }

    public NetworkError put(char c) {
        this.message.put(c);
        return this;
    }

    public NetworkError put(int value) {
        this.message.put(value);
        return this;
    }

    public NetworkError put(long value) {
        this.message.put(value);
        return this;
    }

    public NetworkError put(CharSequence cs) {
        this.message.put(cs);
        return this;
    }

    @Override
    public void toSink(CharSink sink) {
        sink.put("[errno=").put(this.errno).put("] ").put(this.message);
    }
}

