/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractCharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import java.util.Arrays;

public class CharSequenceHashSet
extends AbstractCharSequenceHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final ObjList<CharSequence> list = new ObjList(this.free);
    private boolean hasNull = false;

    public CharSequenceHashSet() {
        this(16);
    }

    public CharSequenceHashSet(CharSequenceHashSet that) {
        this(that.capacity, that.loadFactor);
        this.addAll(that);
    }

    private CharSequenceHashSet(int initialCapacity) {
        this(initialCapacity, 0.4);
    }

    private CharSequenceHashSet(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.clear();
    }

    public boolean add(CharSequence key) {
        if (key == null) {
            return this.addNull();
        }
        int index = this.keyIndex(key);
        if (index < 0) {
            return false;
        }
        this.addAt(index, key);
        return true;
    }

    public final void addAll(CharSequenceHashSet that) {
        int k = that.size();
        for (int i = 0; i < k; ++i) {
            this.add(that.get(i));
        }
    }

    public void addAt(int index, CharSequence key) {
        String s = Chars.toString(key);
        this.keys[index] = s;
        this.list.add(s);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    public boolean addNull() {
        if (this.hasNull) {
            return false;
        }
        --this.free;
        this.hasNull = true;
        this.list.add(null);
        return true;
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, null);
        this.list.clear();
        this.hasNull = false;
    }

    @Override
    public boolean excludes(CharSequence key) {
        return key == null ? !this.hasNull : this.keyIndex(key) > -1;
    }

    @Override
    public int remove(CharSequence key) {
        if (key == null) {
            return this.removeNull();
        }
        int keyIndex = this.keyIndex(key);
        if (keyIndex < 0) {
            this.removeAt(keyIndex);
            return -keyIndex - 1;
        }
        return -1;
    }

    public int getListIndexAt(int keyIndex) {
        int index = -keyIndex - 1;
        return this.list.indexOf(this.keys[index]);
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
    }

    public CharSequence keyAt(int index) {
        int index1 = -index - 1;
        return this.keys[index1];
    }

    public boolean contains(CharSequence key) {
        return key == null ? this.hasNull : this.keyIndex(key) < 0;
    }

    public CharSequence get(int index) {
        return this.list.getQuick(index);
    }

    public CharSequence getLast() {
        return this.list.getLast();
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            int index1 = -index - 1;
            CharSequence key = this.keys[index1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }

    public int removeNull() {
        if (this.hasNull) {
            this.hasNull = false;
            int index = this.list.remove(null);
            ++this.free;
            return index;
        }
        return -1;
    }

    public String toString() {
        return this.list.toString();
    }

    private void rehash() {
        int newCapacity = this.capacity * 2;
        this.mask = newCapacity - 1;
        this.free = this.capacity = newCapacity;
        int arrayCapacity = (int)((double)newCapacity / this.loadFactor);
        this.keys = new CharSequence[arrayCapacity];
        Arrays.fill(this.keys, null);
        int n = this.list.size();
        this.free -= n;
        for (int i = 0; i < n; ++i) {
            CharSequence key;
            this.keys[this.keyIndex((CharSequence)key)] = key = this.list.getQuick(i);
        }
    }
}

