/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractCharSequenceHashSet;
import io.questdb.std.ObjList;
import java.util.Arrays;
import java.util.Comparator;

public class CharSequenceObjHashMap<V>
extends AbstractCharSequenceHashSet {
    private final ObjList<CharSequence> list;
    private V[] values;

    public CharSequenceObjHashMap() {
        this(8);
    }

    private CharSequenceObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private CharSequenceObjHashMap(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.list = new ObjList(this.capacity);
        this.keys = new CharSequence[this.capacity];
        this.values = new Object[this.capacity];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.list.clear();
    }

    public void putAll(CharSequenceObjHashMap<V> other) {
        CharSequence[] otherKeys = other.keys;
        V[] otherValues = other.values;
        int n = otherKeys.length;
        for (int i = 0; i < n; ++i) {
            if (otherKeys[i] == noEntryKey) continue;
            this.put(otherKeys[i], otherValues[i]);
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = null;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            CharSequence key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public V get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public ObjList<CharSequence> keys() {
        return this.list;
    }

    public boolean put(CharSequence key, V value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    public boolean putAt(int index, CharSequence key, V value) {
        if (this.putAt0(index, key, value)) {
            this.list.add(key);
            return true;
        }
        return false;
    }

    public void sortKeys(Comparator<CharSequence> comparator) {
        this.list.sort(comparator);
    }

    public V valueAt(int index) {
        return index < 0 ? (V)this.valueAtQuick(index) : null;
    }

    public V valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    public V valueQuick(int index) {
        return this.get(this.list.getQuick(index));
    }

    private boolean putAt0(int index, CharSequence key, V value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
        return true;
    }

    private void rehash() {
        int size = this.size();
        int newCapacity = this.capacity * 2;
        this.mask = newCapacity - 1;
        this.free = this.capacity = newCapacity;
        int arrayCapacity = (int)((double)newCapacity / this.loadFactor);
        V[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[arrayCapacity];
        this.values = new Object[arrayCapacity];
        Arrays.fill(this.keys, null);
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }
}

