/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.BinarySequence;
import io.questdb.std.Misc;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.str.CharSink;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Chars {
    public static final Comparator<CharSequence> CHAR_SEQUENCE_COMPARATOR = Chars::compare;
    public static final Comparator<CharSequence> CHAR_SEQUENCE_COMPARATOR_DESC = Chars::compareDescending;

    private Chars() {
    }

    public static boolean contains(CharSequence sequence, CharSequence term) {
        int m = term.length();
        if (m == 0) {
            return false;
        }
        int n = sequence.length();
        for (int i = 0; i < n; ++i) {
            if (sequence.charAt(i) != term.charAt(0)) continue;
            if (n - i < m) {
                return false;
            }
            boolean found = true;
            for (int k = 1; k < m && k + i < n; ++k) {
                if (sequence.charAt(i + k) == term.charAt(k)) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return true;
        }
        return false;
    }

    public static boolean endsWith(CharSequence cs, CharSequence ends) {
        if (ends == null || cs == null) {
            return false;
        }
        int l = ends.length();
        if (l == 0) {
            return false;
        }
        int csl = cs.length();
        return csl != 0 && csl >= l && Chars.equals(ends, cs, csl - l, csl);
    }

    public static boolean endsWith(CharSequence cs, char c) {
        if (cs == null) {
            return false;
        }
        int csl = cs.length();
        return csl != 0 && c == cs.charAt(csl - 1);
    }

    public static boolean equals(CharSequence l, CharSequence r) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        return Chars.equalsChars(l, r, ll);
    }

    private static boolean equalsChars(CharSequence l, CharSequence r, int len) {
        for (int i = 0; i < len; ++i) {
            if (l.charAt(i) == r.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence l, CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = l.length();
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence l, int lLo, int lHi, CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (l.charAt(i + lLo) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(CharSequence l, char r) {
        return l.length() == 1 && l.charAt(0) == r;
    }

    public static boolean equalsNc(CharSequence l, char r) {
        return l != null && Chars.equals(l, r);
    }

    public static boolean equalsIgnoreCase(CharSequence l, CharSequence r) {
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Character.toLowerCase(l.charAt(i)) == Character.toLowerCase(r.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsIgnoreCaseNc(CharSequence l, CharSequence r) {
        return l != null && Chars.equalsIgnoreCase(l, r);
    }

    public static boolean equalsLowerCaseAscii(CharSequence l, int lLo, int lHi, CharSequence r, int rLo, int rHi) {
        if (l == r) {
            return true;
        }
        int ll = lHi - lLo;
        if (ll != rHi - rLo) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Chars.toLowerCaseAscii(l.charAt(i + lLo)) == r.charAt(i + rLo)) continue;
            return false;
        }
        return true;
    }

    public static String toLowerCaseAscii(@Nullable CharSequence value) {
        if (value == null) {
            return null;
        }
        int len = value.length();
        if (len == 0) {
            return "";
        }
        StringSink b = Misc.getThreadLocalBuilder();
        for (int i = 0; i < len; ++i) {
            b.put(Chars.toLowerCaseAscii(value.charAt(i)));
        }
        return ((Object)b).toString();
    }

    public static boolean equalsLowerCaseAscii(@NotNull CharSequence l, CharSequence r) {
        int ll = l.length();
        if (ll != r.length()) {
            return false;
        }
        for (int i = 0; i < ll; ++i) {
            if (Chars.toLowerCaseAscii(l.charAt(i)) == r.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean equalsLowerCaseAsciiNc(@Nullable CharSequence l, @NotNull CharSequence r) {
        return l != null && Chars.equalsLowerCaseAscii(l, r);
    }

    public static boolean equalsNc(CharSequence l, CharSequence r) {
        return r != null && Chars.equals(l, r);
    }

    public static int hashCode(CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int hashCode(CharSequence value) {
        if (value instanceof String) {
            return value.hashCode();
        }
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + value.charAt(p);
        }
        return h;
    }

    public static int indexOf(CharSequence s, char c) {
        return Chars.indexOf(s, 0, c);
    }

    public static int indexOf(CharSequence s, int lo, char c) {
        int n = s.length();
        for (int i = lo; i < n; ++i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static boolean isMalformed3(int b1, int b2, int b3) {
        return b1 == -32 && (b2 & 0xE0) == 128 || (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128;
    }

    public static boolean isMalformed4(int b2, int b3, int b4) {
        return (b2 & 0xC0) != 128 || (b3 & 0xC0) != 128 || (b4 & 0xC0) != 128;
    }

    public static boolean isNotContinuation(int b) {
        return (b & 0xC0) != 128;
    }

    public static boolean isQuoted(CharSequence s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        switch (s.charAt(0)) {
            case '\"': 
            case '\'': 
            case '`': {
                return true;
            }
        }
        return false;
    }

    public static int lastIndexOf(CharSequence s, char c) {
        for (int i = s.length() - 1; i > -1; --i) {
            if (s.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    public static int lowerCaseAsciiHashCode(CharSequence value, int lo, int hi) {
        if (hi == lo) {
            return 0;
        }
        int h = 0;
        for (int p = lo; p < hi; ++p) {
            h = 31 * h + Chars.toLowerCaseAscii(value.charAt(p));
        }
        return h;
    }

    public static int lowerCaseAsciiHashCode(CharSequence value) {
        int len = value.length();
        if (len == 0) {
            return 0;
        }
        int h = 0;
        for (int p = 0; p < len; ++p) {
            h = 31 * h + Chars.toLowerCaseAscii(value.charAt(p));
        }
        return h;
    }

    public static boolean noMatch(CharSequence l, int llo, int lhi, CharSequence r, int rlo, int rhi) {
        int lp = llo;
        int rp = rlo;
        while (lp < lhi && rp < rhi) {
            if (Character.toLowerCase(l.charAt(lp++)) == r.charAt(rp++)) continue;
            return true;
        }
        return lp != lhi || rp != rhi;
    }

    public static ObjList<Path> splitLpsz(CharSequence args) {
        ObjList<Path> paths = new ObjList<Path>();
        int n = args.length();
        int lastLen = 0;
        int lastIndex = 0;
        boolean inQuote = false;
        block4: for (int i = 0; i < n; ++i) {
            char b = args.charAt(i);
            switch (b) {
                case ' ': {
                    if (lastLen <= 0) continue block4;
                    if (inQuote) {
                        ++lastLen;
                        continue block4;
                    }
                    paths.add(new Path().of(args, lastIndex, lastLen + lastIndex).$());
                    lastLen = 0;
                    continue block4;
                }
                case '\"': {
                    inQuote = !inQuote;
                    continue block4;
                }
                default: {
                    if (lastLen == 0) {
                        lastIndex = i;
                    }
                    ++lastLen;
                }
            }
        }
        if (lastLen > 0) {
            paths.add(new Path().of(args, lastIndex, lastLen + lastIndex).$());
        }
        return paths;
    }

    public static boolean startsWith(CharSequence _this, CharSequence that) {
        int len = that.length();
        return _this.length() >= len && Chars.equalsChars(_this, that, len);
    }

    public static boolean startsWith(CharSequence _this, int thisLo, int thisHi, CharSequence that) {
        int thisLen = thisHi - thisLo;
        int len = that.length();
        if (thisLen < len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (_this.charAt(thisLo + i) == that.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static boolean startsWith(CharSequence _this, char c) {
        return _this.length() > 0 && _this.charAt(0) == c;
    }

    public static void asciiStrCpy(CharSequence value, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, (byte)value.charAt(i));
        }
    }

    public static void asciiStrCpy(CharSequence value, int lo, int len, long address) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(address + (long)i, (byte)value.charAt(lo + i));
        }
    }

    public static char toLowerCaseAscii(char character) {
        return character > '@' && character < '[' ? (char)(character + 32) : character;
    }

    public static void toSink(BinarySequence sequence, CharSink sink) {
        if (sequence == null) {
            return;
        }
        int len = (int)sequence.length();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                if (i % 16 == 0) {
                    sink.put('\n');
                    Numbers.appendHexPadded(sink, i);
                }
            } else {
                Numbers.appendHexPadded(sink, i);
            }
            sink.put(' ');
            int b = sequence.byteAt(i);
            int v = b < 0 ? 256 + b : b;
            if (v < 16) {
                sink.put('0');
                sink.put(Numbers.hexDigits[b]);
                continue;
            }
            sink.put(Numbers.hexDigits[v / 16]);
            sink.put(Numbers.hexDigits[v % 16]);
        }
    }

    public static String toString(CharSequence s) {
        return s == null ? null : s.toString();
    }

    public static String toString(CharSequence cs, int start, int end) {
        StringSink b = Misc.getThreadLocalBuilder();
        b.put(cs, start, end);
        return ((Object)b).toString();
    }

    public static String stringFromUtf8Bytes(long lo, long hi) {
        if (hi == lo) {
            return "";
        }
        StringSink b = Misc.getThreadLocalBuilder();
        Chars.utf8Decode(lo, hi, b);
        return ((Object)b).toString();
    }

    public static boolean utf8Decode(long lo, long hi, CharSink sink) {
        long p = lo;
        while (p < hi) {
            byte b = Unsafe.getUnsafe().getByte(p);
            if (b < 0) {
                int n = Chars.utf8DecodeMultiByte(p, hi, b, sink);
                if (n == -1) {
                    return false;
                }
                p += (long)n;
                continue;
            }
            sink.put((char)b);
            ++p;
        }
        return true;
    }

    public static int utf8DecodeMultiByte(long lo, long hi, int b, CharSink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Chars.utf8Decode2Bytes(lo, hi, b, sink);
        }
        if (b >> 4 == -2) {
            return Chars.utf8Decode3Bytes(lo, hi, b, sink);
        }
        return Chars.utf8Decode4Bytes(lo, b, hi, sink);
    }

    public static int utf8DecodeMultiByteZ(long lo, int b, CharSink sink) {
        if (b >> 5 == -2 && (b & 0x1E) != 0) {
            return Chars.utf8Decode2BytesZ(lo, b, sink);
        }
        if (b >> 4 == -2) {
            return Chars.utf8Decode3BytesZ(lo, b, sink);
        }
        return Chars.utf8Decode4BytesZ(lo, b, sink);
    }

    public static boolean utf8DecodeZ(long lo, CharSink sink) {
        byte b;
        long p = lo;
        while ((b = Unsafe.getUnsafe().getByte(p)) != 0) {
            if (b < 0) {
                int n = Chars.utf8DecodeMultiByteZ(p, b, sink);
                if (n == -1) {
                    return false;
                }
                p += (long)n;
                continue;
            }
            sink.put((char)b);
            ++p;
        }
        return true;
    }

    private static int utf8error() {
        return -1;
    }

    private static int utf8Decode4Bytes(long lo, int b, long hi, CharSink sink) {
        if (b >> 3 != -2 || hi - lo < 4L) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        byte b4 = Unsafe.getUnsafe().getByte(lo + 3L);
        return Chars.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8Decode4Bytes0(int b, CharSink sink, byte b2, byte b3, byte b4) {
        if (Chars.isMalformed4(b2, b3, b4)) {
            return Chars.utf8error();
        }
        int codePoint = b << 18 ^ b2 << 12 ^ b3 << 6 ^ b4 ^ 0x381F80;
        if (Character.isSupplementaryCodePoint(codePoint)) {
            sink.put(Character.highSurrogate(codePoint));
            sink.put(Character.lowSurrogate(codePoint));
            return 4;
        }
        return Chars.utf8error();
    }

    private static int utf8Decode4BytesZ(long lo, int b, CharSink sink) {
        if (b >> 3 != -2) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return Chars.utf8error();
        }
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        if (b3 == 0) {
            return Chars.utf8error();
        }
        byte b4 = Unsafe.getUnsafe().getByte(lo + 3L);
        if (b4 == 0) {
            return Chars.utf8error();
        }
        return Chars.utf8Decode4Bytes0(b, sink, b2, b3, b4);
    }

    private static int utf8Decode3Bytes(long lo, long hi, int b1, CharSink sink) {
        byte b3;
        if (hi - lo < 3L) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (Chars.isMalformed3(b1, b2, b3 = Unsafe.getUnsafe().getByte(lo + 2L))) {
            return Chars.utf8error();
        }
        char c = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80);
        if (Character.isSurrogate(c)) {
            return Chars.utf8error();
        }
        sink.put(c);
        return 3;
    }

    private static int utf8Decode3BytesZ(long lo, int b1, CharSink sink) {
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return Chars.utf8error();
        }
        byte b3 = Unsafe.getUnsafe().getByte(lo + 2L);
        if (b3 == 0) {
            return Chars.utf8error();
        }
        if (Chars.isMalformed3(b1, b2, b3)) {
            return Chars.utf8error();
        }
        char c = (char)(b1 << 12 ^ b2 << 6 ^ b3 ^ 0xFFFE1F80);
        if (Character.isSurrogate(c)) {
            return Chars.utf8error();
        }
        sink.put(c);
        return 3;
    }

    private static int utf8Decode2Bytes(long lo, long hi, int b1, CharSink sink) {
        if (hi - lo < 2L) {
            return Chars.utf8error();
        }
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (Chars.isNotContinuation(b2)) {
            return Chars.utf8error();
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    private static int utf8Decode2BytesZ(long lo, int b1, CharSink sink) {
        byte b2 = Unsafe.getUnsafe().getByte(lo + 1L);
        if (b2 == 0) {
            return Chars.utf8error();
        }
        if (Chars.isNotContinuation(b2)) {
            return Chars.utf8error();
        }
        sink.put((char)(b1 << 6 ^ b2 ^ 0xF80));
        return 2;
    }

    public static int compareDescending(CharSequence l, CharSequence r) {
        return Chars.compare(r, l);
    }

    public static int compare(CharSequence l, CharSequence r) {
        if (l == r) {
            return 0;
        }
        if (l == null) {
            return -1;
        }
        if (r == null) {
            return 1;
        }
        int ll = l.length();
        int rl = r.length();
        int min = Math.min(ll, rl);
        for (int i = 0; i < min; ++i) {
            int k = l.charAt(i) - r.charAt(i);
            if (k == 0) continue;
            return k;
        }
        return Integer.compare(ll, rl);
    }

    public static void asciiCopyTo(char[] chars, int start, int len, long dest) {
        for (int i = 0; i < len; ++i) {
            Unsafe.getUnsafe().putByte(dest + (long)i, (byte)chars[i + start]);
        }
    }
}

