/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Chars;
import io.questdb.std.Os;
import io.questdb.std.Unsafe;
import io.questdb.std.str.LPSZ;
import io.questdb.std.str.Path;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicLong;

public final class Files {
    public static final Charset UTF_8;
    public static final long PAGE_SIZE;
    public static final int DT_DIR = 4;
    public static final int MAP_RO = 1;
    public static final int MAP_RW = 2;
    public static final char SEPARATOR;
    static final AtomicLong OPEN_FILE_COUNT;

    private Files() {
    }

    public static native long append(long var0, long var2, long var4);

    public static int close(long fd) {
        int res = Files.close0(fd);
        if (res == 0) {
            OPEN_FILE_COUNT.decrementAndGet();
        }
        return res;
    }

    public static native boolean exists(long var0);

    public static boolean exists(LPSZ lpsz) {
        return lpsz != null && Files.exists0(lpsz.address());
    }

    private static native boolean exists0(long var0);

    public static native void findClose(long var0);

    public static long findFirst(LPSZ lpsz) {
        return Files.findFirst(lpsz.address());
    }

    public static native long findName(long var0);

    public static native int findNext(long var0);

    public static native int findType(long var0);

    public static long getLastModified(LPSZ lpsz) {
        return Files.getLastModified(lpsz.address());
    }

    public static long getOpenFileCount() {
        return OPEN_FILE_COUNT.get();
    }

    public static native long getStdOutFd();

    public static boolean isDots(CharSequence name) {
        return Chars.equals(name, '.') || Chars.equals(name, "..");
    }

    public static long length(LPSZ lpsz) {
        return Files.length0(lpsz.address());
    }

    public static native long length(long var0);

    public static native int lock(long var0);

    public static native int msync(long var0, long var2, boolean var4);

    public static int mkdir(LPSZ path, int mode) {
        return Files.mkdir(path.address(), mode);
    }

    public static int mkdirs(LPSZ path, int mode) {
        try (Path pp = new Path();){
            int n = path.length();
            for (int i = 0; i < n; ++i) {
                char c = path.charAt(i);
                if (c == File.separatorChar) {
                    int r;
                    if (i == 2 && Os.type == 3 && path.charAt(1) == ':') {
                        pp.put(c);
                        continue;
                    }
                    pp.$();
                    if (pp.length() > 0 && !Files.exists(pp) && (r = Files.mkdir(pp, mode)) != 0) {
                        int n2 = r;
                        return n2;
                    }
                    pp.chopZ();
                }
                pp.put(c);
            }
        }
        return 0;
    }

    public static long mmap(long fd, long len, long offset, int flags) {
        long address = Files.mmap0(fd, len, offset, flags);
        if (address != -1L) {
            Unsafe.recordMemAlloc(len);
        }
        return address;
    }

    public static void munmap(long address, long len) {
        if (address != 0L && Files.munmap0(address, len) != -1) {
            Unsafe.recordMemAlloc(-len);
        }
    }

    public static long openAppend(LPSZ lpsz) {
        long fd = Files.openAppend(lpsz.address());
        if (fd != -1L) {
            Files.bumpFileCount();
        }
        return fd;
    }

    public static long openRO(LPSZ lpsz) {
        long fd = Files.openRO(lpsz.address());
        if (fd != -1L) {
            Files.bumpFileCount();
        }
        return fd;
    }

    public static long openRW(LPSZ lpsz) {
        long fd = Files.openRW(lpsz.address());
        if (fd != -1L) {
            Files.bumpFileCount();
        }
        return fd;
    }

    public static void bumpFileCount() {
        OPEN_FILE_COUNT.incrementAndGet();
    }

    public static native long read(long var0, long var2, long var4, long var6);

    public static boolean remove(LPSZ lpsz) {
        return Files.remove(lpsz.address());
    }

    public static boolean rename(LPSZ oldName, LPSZ newName) {
        return Files.rename(oldName.address(), newName.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean rmdir(Path path) {
        long p = Files.findFirst(path.address());
        int len = path.length();
        boolean clean = true;
        if (p > 0L) {
            try {
                do {
                    long lpszName = Files.findName(p);
                    path.trimTo(len).concat(lpszName).$();
                    if (Files.findType(p) == 4) {
                        if (Files.strcmp(lpszName, "..") || Files.strcmp(lpszName, ".") || Files.rmdir(path)) continue;
                        clean = false;
                        continue;
                    }
                    if (Files.remove(path.address())) continue;
                    clean = false;
                } while (Files.findNext(p) > 0);
            }
            finally {
                Files.findClose(p);
            }
            return Files.rmdir(path.trimTo(len).$().address()) && clean;
        }
        return false;
    }

    public static native long sequentialRead(long var0, long var2, int var4);

    public static boolean setLastModified(LPSZ lpsz, long millis) {
        return Files.setLastModified(lpsz.address(), millis);
    }

    public static boolean touch(LPSZ lpsz) {
        boolean result;
        long fd = Files.openRW(lpsz);
        boolean bl = result = fd > 0L;
        if (result) {
            Files.close(fd);
        }
        return result;
    }

    public static native boolean truncate(long var0, long var2);

    public static native long write(long var0, long var2, long var4, long var6);

    static native int close0(long var0);

    private static boolean strcmp(long lpsz, CharSequence s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            byte b = Unsafe.getUnsafe().getByte(lpsz + (long)i);
            if (b != 0 && b == (byte)s.charAt(i)) continue;
            return false;
        }
        return Unsafe.getUnsafe().getByte(lpsz + (long)len) == 0;
    }

    private static native int munmap0(long var0, long var2);

    private static native long mmap0(long var0, long var2, long var4, int var6);

    private static native long getPageSize();

    private static native boolean remove(long var0);

    private static native boolean rmdir(long var0);

    private static native long getLastModified(long var0);

    private static native long length0(long var0);

    private static native int mkdir(long var0, int var2);

    private static native long openRO(long var0);

    private static native long openRW(long var0);

    private static native long openAppend(long var0);

    private static native long findFirst(long var0);

    private static native boolean setLastModified(long var0, long var2);

    private static native boolean rename(long var0, long var2);

    static {
        OPEN_FILE_COUNT = new AtomicLong();
        Os.init();
        UTF_8 = StandardCharsets.UTF_8;
        PAGE_SIZE = Files.getPageSize();
        SEPARATOR = (char)(Os.type == 3 ? 92 : 47);
    }
}

