/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractIntHashSet;
import java.util.Arrays;

public class IntObjHashMap<V>
extends AbstractIntHashSet {
    private V[] values;

    public IntObjHashMap() {
        this(8);
    }

    public IntObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public IntObjHashMap(int initialCapacity, double loadFactor, int noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.values = new Object[this.keys.length];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        Arrays.fill(this.values, null);
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
        this.values[index] = null;
    }

    public V valueAt(int index) {
        return index < 0 ? (V)this.valueAtQuick(index) : null;
    }

    public V valueAtQuick(int index) {
        return this.values[-index - 1];
    }

    public V get(int key) {
        return this.valueAt(this.keyIndex(key));
    }

    public void put(int key, V value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public void putAt(int index, int key, V value) {
        if (index < 0) {
            this.values[-index - 1] = value;
        } else {
            this.keys[index] = key;
            this.values[index] = value;
            if (--this.free == 0) {
                this.rehash();
            }
        }
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private void rehash() {
        int size = this.size();
        int newCapacity = this.capacity * 2;
        this.mask = newCapacity - 1;
        this.free = this.capacity = newCapacity;
        int arrayCapacity = (int)((double)newCapacity / this.loadFactor);
        V[] oldValues = this.values;
        int[] oldKeys = this.keys;
        this.keys = new int[arrayCapacity];
        this.values = new Object[arrayCapacity];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            int key = oldKeys[i];
            if (key == this.noEntryKeyValue) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }
}

