/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLongHashSet;
import io.questdb.std.LongList;
import java.util.Arrays;

public class LongHashSet
extends AbstractLongHashSet {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private final LongList list;

    public LongHashSet() {
        this(16);
    }

    public LongHashSet(LongHashSet that) {
        this(that.capacity, that.loadFactor, -1L);
        this.addAll(that);
    }

    public LongHashSet(int initialCapacity) {
        this(initialCapacity, 0.4, -1L);
    }

    public LongHashSet(int initialCapacity, double loadFactor, long noKeyValue) {
        super(initialCapacity, loadFactor, noKeyValue);
        this.list = new LongList(this.free);
        this.clear();
    }

    public void add(long key) {
        int index = this.keyIndex(key);
        if (index < 0) {
            return;
        }
        this.addAt(index, key);
    }

    public final void addAll(LongHashSet that) {
        int k = that.size();
        for (int i = 0; i < k; ++i) {
            this.add(that.get(i));
        }
    }

    public void addAt(int index, long key) {
        this.keys[index] = key;
        this.list.add(key);
        if (--this.free < 1) {
            this.rehash();
        }
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.list.clear();
    }

    @Override
    public boolean excludes(long key) {
        return this.keyIndex(key) > -1;
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            long key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }

    public boolean contains(long key) {
        return this.keyIndex(key) < 0;
    }

    public long get(int index) {
        return this.list.getQuick(index);
    }

    public long getLast() {
        return this.list.getLast();
    }

    public String toString() {
        return this.list.toString();
    }

    private void rehash() {
        int newCapacity = this.capacity * 2;
        this.mask = newCapacity - 1;
        this.free = this.capacity = newCapacity;
        int arrayCapacity = (int)((double)newCapacity / this.loadFactor);
        this.keys = new long[arrayCapacity];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        int n = this.list.size();
        this.free -= n;
        for (int i = 0; i < n; ++i) {
            long key = this.list.getQuick(i);
            int keyIndex = this.keyIndex(key);
            this.keys[keyIndex] = key;
        }
    }
}

