/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLongHashSet;
import io.questdb.std.Mutable;
import java.util.Arrays;

public class LongIntHashMap
extends AbstractLongHashSet
implements Mutable {
    public static final int NO_ENTRY_VALUE = -1;
    private int[] values;

    public LongIntHashMap() {
        this(8);
    }

    public LongIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    private LongIntHashMap(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.values = new int[this.keys.length];
        this.clear();
    }

    public int get(long key) {
        return this.valueAt(this.keyIndex(key));
    }

    public void put(long key, int value) {
        this.putAt(this.keyIndex(key), key, value);
    }

    public void putAt(int index, long key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
        } else {
            this.keys[index] = key;
            this.values[index] = value;
            if (--this.free == 0) {
                this.rehash();
            }
        }
    }

    public int valueAt(int index) {
        return index < 0 ? this.values[-index - 1] : -1;
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = this.noEntryKeyValue;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private void rehash() {
        int size = this.size();
        int newCapacity = this.capacity * 2;
        this.mask = newCapacity - 1;
        this.free = this.capacity = newCapacity;
        int arrayCapacity = (int)((double)newCapacity / this.loadFactor);
        int[] oldValues = this.values;
        long[] oldKeys = this.keys;
        this.keys = new long[arrayCapacity];
        this.values = new int[arrayCapacity];
        Arrays.fill(this.keys, this.noEntryKeyValue);
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            long key = oldKeys[i];
            if (key == this.noEntryKeyValue) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }
}

