/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.Chars;
import java.util.Arrays;

public class LowerCaseAsciiCharSequenceIntHashMap
extends AbstractLowerCaseAsciiCharSequenceHashSet {
    private static final int NO_ENTRY_VALUE = -1;
    private final int noEntryValue;
    private int[] values;

    public LowerCaseAsciiCharSequenceIntHashMap() {
        this(8);
    }

    public LowerCaseAsciiCharSequenceIntHashMap(int initialCapacity) {
        this(initialCapacity, 0.5, -1);
    }

    public LowerCaseAsciiCharSequenceIntHashMap(int initialCapacity, double loadFactor, int noEntryValue) {
        super(initialCapacity, loadFactor);
        this.noEntryValue = noEntryValue;
        this.values = new int[this.capacity];
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        Arrays.fill(this.values, this.noEntryValue);
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = this.noEntryValue;
    }

    public int valueAt(int index) {
        return index < 0 ? this.values[-index - 1] : this.noEntryValue;
    }

    public boolean contains(CharSequence key) {
        return this.keyIndex(key) < 0;
    }

    public int get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public boolean put(CharSequence key, int value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, int value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        this.putAt0(index, Chars.toLowerCaseAscii(key), value);
        return true;
    }

    public void putIfAbsent(CharSequence key, int value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt0(index, Chars.toLowerCaseAscii(key), value);
        }
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private void putAt0(int index, CharSequence key, int value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        int size = this.size();
        int newCapacity = this.capacity * 2;
        this.mask = newCapacity - 1;
        this.free = this.capacity = newCapacity;
        int arrayCapacity = (int)((double)newCapacity / this.loadFactor);
        int[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[arrayCapacity];
        this.values = new int[arrayCapacity];
        Arrays.fill(this.keys, null);
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }
}

