/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.AbstractLowerCaseAsciiCharSequenceHashSet;
import io.questdb.std.Chars;
import io.questdb.std.ObjList;
import java.util.Arrays;

public class LowerCaseAsciiCharSequenceObjHashMap<T>
extends AbstractLowerCaseAsciiCharSequenceHashSet {
    private final ObjList<CharSequence> list;
    private T[] values;

    public LowerCaseAsciiCharSequenceObjHashMap() {
        this(8);
    }

    public LowerCaseAsciiCharSequenceObjHashMap(int initialCapacity) {
        this(initialCapacity, 0.5);
    }

    public LowerCaseAsciiCharSequenceObjHashMap(int initialCapacity, double loadFactor) {
        super(initialCapacity, loadFactor);
        this.values = new Object[this.capacity];
        this.list = new ObjList(this.capacity);
        this.clear();
    }

    @Override
    public final void clear() {
        super.clear();
        this.list.clear();
        Arrays.fill(this.values, null);
    }

    @Override
    protected void erase(int index) {
        this.keys[index] = noEntryKey;
        this.values[index] = null;
    }

    public T valueAt(int index) {
        return index < 0 ? (T)this.values[-index - 1] : null;
    }

    public boolean contains(CharSequence key) {
        return this.keyIndex(key) < 0;
    }

    public T get(CharSequence key) {
        return this.valueAt(this.keyIndex(key));
    }

    public boolean put(CharSequence key, T value) {
        return this.putAt(this.keyIndex(key), key, value);
    }

    public boolean putAt(int index, CharSequence key, T value) {
        if (index < 0) {
            this.values[-index - 1] = value;
            return false;
        }
        String lcKey = Chars.toLowerCaseAscii(key);
        this.putAt0(index, lcKey, value);
        this.list.add(lcKey);
        return true;
    }

    public void putIfAbsent(CharSequence key, T value) {
        int index = this.keyIndex(key);
        if (index > -1) {
            this.putAt0(index, Chars.toLowerCaseAscii(key), value);
        }
    }

    @Override
    public void removeAt(int index) {
        if (index < 0) {
            CharSequence key = this.keys[-index - 1];
            super.removeAt(index);
            this.list.remove(key);
        }
    }

    public ObjList<CharSequence> keys() {
        return this.list;
    }

    @Override
    protected void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.values[to] = this.values[from];
        this.erase(from);
    }

    private void putAt0(int index, CharSequence key, T value) {
        this.keys[index] = key;
        this.values[index] = value;
        if (--this.free == 0) {
            this.rehash();
        }
    }

    private void rehash() {
        int size = this.size();
        int newCapacity = this.capacity * 2;
        this.mask = newCapacity - 1;
        this.free = this.capacity = newCapacity;
        int arrayCapacity = (int)((double)newCapacity / this.loadFactor);
        T[] oldValues = this.values;
        CharSequence[] oldKeys = this.keys;
        this.keys = new CharSequence[arrayCapacity];
        this.values = new Object[arrayCapacity];
        Arrays.fill(this.keys, null);
        this.free -= size;
        int i = oldKeys.length;
        while (i-- > 0) {
            CharSequence key = oldKeys[i];
            if (key == null) continue;
            int index = this.keyIndex(key);
            this.keys[index] = key;
            this.values[index] = oldValues[i];
        }
    }
}

