/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.ObjList;
import io.questdb.std.ThreadLocal;
import io.questdb.std.ex.FatalError;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.io.IOException;

public final class Misc {
    public static final String EOL = "\r\n";
    private static final ThreadLocal<StringSink> tlBuilder = new ThreadLocal<StringSink>(StringSink::new);

    private Misc() {
    }

    public static <T> T free(T object) {
        if (object instanceof Closeable) {
            try {
                ((Closeable)object).close();
            }
            catch (IOException e) {
                throw new FatalError(e);
            }
        }
        return null;
    }

    public static StringSink getThreadLocalBuilder() {
        StringSink b = (StringSink)tlBuilder.get();
        b.clear();
        return b;
    }

    public static <T> void freeObjList(ObjList<T> list) {
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                list.setQuick(i, Misc.free(list.getQuick(i)));
            }
        }
    }
}

