/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.Hash;
import io.questdb.std.Mutable;
import io.questdb.std.Numbers;
import io.questdb.std.ObjList;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class ObjHashSet<T>
extends AbstractSet<T>
implements Mutable {
    private static final int MIN_INITIAL_CAPACITY = 16;
    private static final Object noEntryKey = new Object();
    private final double loadFactor;
    private final ObjList<T> list;
    private T[] keys;
    private int free;
    private int capacity;
    private int mask;

    public ObjHashSet() {
        this(16);
    }

    public ObjHashSet(int initialCapacity) {
        this(initialCapacity, 0.4f, 0.3f);
    }

    private ObjHashSet(int initialCapacity, double loadFactor, double hashFactor) {
        if (loadFactor <= 0.0 || loadFactor >= 1.0) {
            throw new IllegalArgumentException("0 < loadFactor < 1");
        }
        if (hashFactor <= 0.0 || hashFactor >= 1.0) {
            throw new IllegalArgumentException("0 < hashFactor < 1");
        }
        initialCapacity = (int)((double)initialCapacity * (1.0 + hashFactor));
        int capacity = Math.max(initialCapacity, (int)((double)initialCapacity / loadFactor));
        this.loadFactor = loadFactor;
        this.keys = new Object[capacity < 16 ? 16 : Numbers.ceilPow2(capacity)];
        this.mask = this.keys.length - 1;
        this.free = this.capacity = initialCapacity;
        this.list = new ObjList(this.free);
        this.clear();
    }

    public void addAll(ObjHashSet<? extends T> that) {
        int n = that.size();
        for (int i = 0; i < n; ++i) {
            this.add(that.get(i));
        }
    }

    public boolean addAt(int index, T key) {
        if (this.addAt0(index, key)) {
            this.list.add(key);
            return true;
        }
        return false;
    }

    public T get(int index) {
        return this.list.getQuick(index);
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.capacity - this.free;
    }

    @Override
    public boolean contains(Object o) {
        return this.keyIndex(o) < 0;
    }

    @Override
    public boolean add(T key) {
        return this.addAt(this.keyIndex(key), key);
    }

    public int keyIndex(T key) {
        int index = this.idx(key);
        T kv = this.keys[index];
        if (kv == noEntryKey) {
            return index;
        }
        if (kv == key || key.equals(kv)) {
            return -index - 1;
        }
        return this.probe(key, index);
    }

    @Override
    public boolean remove(Object key) {
        int keyIndex = this.keyIndex(key);
        if (keyIndex < 0) {
            this.list.remove(this.keys[-keyIndex - 1]);
            this.removeAt(keyIndex);
            return true;
        }
        return false;
    }

    @Override
    public final void clear() {
        this.free = this.capacity;
        Arrays.fill(this.keys, noEntryKey);
        this.list.clear();
    }

    @Override
    public String toString() {
        return this.list.toString();
    }

    private boolean addAt0(int index, T key) {
        if (index > -1) {
            this.keys[index] = key;
            if (--this.free == 0) {
                this.rehash();
            }
            return true;
        }
        return false;
    }

    private void erase(int index) {
        this.keys[index] = noEntryKey;
    }

    private int idx(T key) {
        return key == null ? 0 : Hash.spread(key.hashCode()) & this.mask;
    }

    private void move(int from, int to) {
        this.keys[to] = this.keys[from];
        this.erase(from);
    }

    private int probe(T key, int index) {
        T kv;
        do {
            if ((kv = this.keys[index = index + 1 & this.mask]) != noEntryKey) continue;
            return index;
        } while (kv != key && !key.equals(kv));
        return -index - 1;
    }

    private void rehash() {
        int newCapacity = this.keys.length << 1;
        this.mask = newCapacity - 1;
        this.free = this.capacity = (int)((double)newCapacity * this.loadFactor);
        T[] oldKeys = this.keys;
        this.keys = new Object[newCapacity];
        Arrays.fill(this.keys, noEntryKey);
        int i = oldKeys.length;
        while (i-- > 0) {
            T key = oldKeys[i];
            if (key == noEntryKey) continue;
            this.addAt0(this.keyIndex(key), key);
        }
    }

    private void removeAt(int index) {
        if (index < 0) {
            int from = -index - 1;
            this.erase(from);
            ++this.free;
            from = from + 1 & this.mask;
            T key = this.keys[from];
            while (key != noEntryKey) {
                int to;
                int idealHit = Hash.spread(key.hashCode()) & this.mask;
                if (idealHit != from && (to = this.keys[idealHit] != noEntryKey ? this.probe(key, idealHit) : idealHit) > -1) {
                    this.move(from, to);
                }
                from = from + 1 & this.mask;
                key = this.keys[from];
            }
        }
    }
}

