/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std;

import io.questdb.std.ex.FatalError;
import java.lang.reflect.Field;
import java.util.concurrent.atomic.AtomicLong;

public final class Unsafe {
    public static final long INT_OFFSET;
    public static final long INT_SCALE;
    public static final long LONG_OFFSET;
    public static final long LONG_SCALE;
    static final AtomicLong MEM_USED;
    private static final sun.misc.Unsafe UNSAFE;
    private static final AtomicLong MALLOC_COUNT;
    private static final AtomicLong FREE_COUNT;

    private Unsafe() {
    }

    public static long arrayGetVolatile(long[] array, int index) {
        assert (index > -1 && index < array.length);
        return Unsafe.getUnsafe().getLongVolatile(array, LONG_OFFSET + (long)(index << (int)LONG_SCALE));
    }

    public static void arrayPutOrdered(long[] array, int index, long value) {
        assert (index > -1 && index < array.length);
        Unsafe.getUnsafe().putOrderedLong(array, LONG_OFFSET + (long)(index << (int)LONG_SCALE), value);
    }

    public static long calloc(long size) {
        long ptr = Unsafe.malloc(size);
        Unsafe.getUnsafe().setMemory(ptr, size, (byte)0);
        return ptr;
    }

    public static boolean cas(Object o, long offset, long expected, long value) {
        return UNSAFE.compareAndSwapLong(o, offset, expected, value);
    }

    public static boolean cas(Object o, long offset, int expected, int value) {
        return UNSAFE.compareAndSwapInt(o, offset, expected, value);
    }

    public static boolean cas(long[] array, int index, long expected, long value) {
        assert (index > -1 && index < array.length);
        return Unsafe.cas((Object)array, LONG_OFFSET + ((long)index << (int)LONG_SCALE), expected, value);
    }

    public static void free(long ptr, long size) {
        Unsafe.getUnsafe().freeMemory(ptr);
        FREE_COUNT.incrementAndGet();
        Unsafe.recordMemAlloc(-size);
    }

    public static boolean getBool(long address) {
        return UNSAFE.getByte(address) == 1;
    }

    public static long getFieldOffset(Class<?> clazz, String name) {
        try {
            Field f = clazz.getDeclaredField(name);
            f.setAccessible(true);
            return UNSAFE.objectFieldOffset(f);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public static long getFreeCount() {
        return FREE_COUNT.get();
    }

    public static long getMallocCount() {
        return MALLOC_COUNT.get();
    }

    public static long getMemUsed() {
        return MEM_USED.get();
    }

    public static sun.misc.Unsafe getUnsafe() {
        return UNSAFE;
    }

    public static long malloc(long size) {
        long ptr = Unsafe.getUnsafe().allocateMemory(size);
        Unsafe.recordMemAlloc(size);
        MALLOC_COUNT.incrementAndGet();
        return ptr;
    }

    public static long realloc(long address, long oldSize, long newSize) {
        long ptr = Unsafe.getUnsafe().reallocateMemory(address, newSize);
        Unsafe.recordMemAlloc(-oldSize + newSize);
        return ptr;
    }

    static void recordMemAlloc(long size) {
        MEM_USED.addAndGet(size);
    }

    private static int msb(int value) {
        return 31 - Integer.numberOfLeadingZeros(value);
    }

    static {
        MEM_USED = new AtomicLong(0L);
        MALLOC_COUNT = new AtomicLong(0L);
        FREE_COUNT = new AtomicLong(0L);
        try {
            Field theUnsafe = sun.misc.Unsafe.class.getDeclaredField("theUnsafe");
            theUnsafe.setAccessible(true);
            UNSAFE = (sun.misc.Unsafe)theUnsafe.get(null);
            INT_OFFSET = Unsafe.getUnsafe().arrayBaseOffset(int[].class);
            INT_SCALE = Unsafe.msb(Unsafe.getUnsafe().arrayIndexScale(int[].class));
            LONG_OFFSET = Unsafe.getUnsafe().arrayBaseOffset(long[].class);
            LONG_SCALE = Unsafe.msb(Unsafe.getUnsafe().arrayIndexScale(long[].class));
        }
        catch (Exception e) {
            throw new FatalError(e);
        }
    }
}

