/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.microtime;

import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.microtime.AbstractTimestampFormat;
import io.questdb.std.microtime.DateFormatUtils;
import io.questdb.std.microtime.TimestampLocale;
import io.questdb.std.microtime.Timestamps;
import io.questdb.std.str.CharSink;

public class GenericTimestampFormat
extends AbstractTimestampFormat {
    private final IntList compiledOps;
    private final ObjList<String> delimiters;

    public GenericTimestampFormat(IntList compiledOps, ObjList<String> delimiters) {
        this.compiledOps = compiledOps;
        this.delimiters = delimiters;
    }

    @Override
    public void format(long micros, TimestampLocale locale, CharSequence timeZoneName, CharSink sink) {
        int day = -1;
        int month = -1;
        int year = Integer.MIN_VALUE;
        int hour = -1;
        int minute = -1;
        int second = -1;
        int dayOfWeek = -1;
        boolean leap = false;
        int millis = -1;
        int micros0 = -1;
        int n = this.compiledOps.size();
        block33: for (int i = 0; i < n; ++i) {
            int op = this.compiledOps.getQuick(i);
            switch (op) {
                case 14: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    DateFormatUtils.appendAmPm(sink, hour, locale);
                    continue block33;
                }
                case 39: 
                case 149: {
                    if (micros0 == -1) {
                        micros0 = Timestamps.getMicrosOfSecond(micros);
                    }
                    sink.put(micros0);
                    continue block33;
                }
                case 49: {
                    if (micros0 == -1) {
                        micros0 = Timestamps.getMicrosOfSecond(micros);
                    }
                    DateFormatUtils.append00(sink, micros0);
                    continue block33;
                }
                case 21: 
                case 146: {
                    if (millis == -1) {
                        millis = Timestamps.getMillisOfSecond(micros);
                    }
                    sink.put(millis);
                    continue block33;
                }
                case 31: {
                    if (millis == -1) {
                        millis = Timestamps.getMillisOfSecond(micros);
                    }
                    DateFormatUtils.append00(sink, millis);
                    continue block33;
                }
                case 20: 
                case 145: {
                    if (second == -1) {
                        second = Timestamps.getSecondOfMinute(micros);
                    }
                    sink.put(second);
                    continue block33;
                }
                case 30: {
                    if (second == -1) {
                        second = Timestamps.getSecondOfMinute(micros);
                    }
                    DateFormatUtils.append0(sink, second);
                    continue block33;
                }
                case 19: 
                case 144: {
                    if (minute == -1) {
                        minute = Timestamps.getMinuteOfHour(micros);
                    }
                    sink.put(minute);
                    continue block33;
                }
                case 29: {
                    if (minute == -1) {
                        minute = Timestamps.getMinuteOfHour(micros);
                    }
                    DateFormatUtils.append0(sink, minute);
                    continue block33;
                }
                case 17: 
                case 142: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    DateFormatUtils.appendHour12(sink, hour);
                    continue block33;
                }
                case 34: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    DateFormatUtils.appendHour12Padded(sink, hour);
                    continue block33;
                }
                case 18: 
                case 143: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    DateFormatUtils.appendHour121(sink, hour);
                    continue block33;
                }
                case 35: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    DateFormatUtils.appendHour121Padded(sink, hour);
                    continue block33;
                }
                case 15: 
                case 140: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    sink.put(hour);
                    continue block33;
                }
                case 32: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    DateFormatUtils.append0(sink, hour);
                    continue block33;
                }
                case 16: 
                case 141: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    sink.put(hour + 1);
                    continue block33;
                }
                case 33: {
                    if (hour == -1) {
                        hour = Timestamps.getHourOfDay(micros);
                    }
                    DateFormatUtils.append0(sink, hour + 1);
                    continue block33;
                }
                case 9: 
                case 139: {
                    if (day == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        if (month == -1) {
                            month = Timestamps.getMonthOfYear(micros, year, leap);
                        }
                        day = Timestamps.getDayOfMonth(micros, year, month, leap);
                    }
                    sink.put(day);
                    continue block33;
                }
                case 10: {
                    if (day == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        if (month == -1) {
                            month = Timestamps.getMonthOfYear(micros, year, leap);
                        }
                        day = Timestamps.getDayOfMonth(micros, year, month, leap);
                    }
                    DateFormatUtils.append0(sink, day);
                    continue block33;
                }
                case 12: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Timestamps.getDayOfWeekSundayFirst(micros);
                    }
                    sink.put(locale.getWeekday(dayOfWeek));
                    continue block33;
                }
                case 11: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Timestamps.getDayOfWeekSundayFirst(micros);
                    }
                    sink.put(locale.getShortWeekday(dayOfWeek));
                    continue block33;
                }
                case 13: {
                    if (dayOfWeek == -1) {
                        dayOfWeek = Timestamps.getDayOfWeekSundayFirst(micros);
                    }
                    sink.put(dayOfWeek);
                    continue block33;
                }
                case 5: 
                case 135: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    sink.put(month);
                    continue block33;
                }
                case 6: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    DateFormatUtils.append0(sink, month);
                    continue block33;
                }
                case 7: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    sink.put(locale.getShortMonth(month - 1));
                    continue block33;
                }
                case 8: {
                    if (month == -1) {
                        if (year == Integer.MIN_VALUE) {
                            year = Timestamps.getYear(micros);
                            leap = Timestamps.isLeapYear(year);
                        }
                        month = Timestamps.getMonthOfYear(micros, year, leap);
                    }
                    sink.put(locale.getMonth(month - 1));
                    continue block33;
                }
                case 2: 
                case 132: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    sink.put(year);
                    continue block33;
                }
                case 3: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    DateFormatUtils.append0(sink, year % 100);
                    continue block33;
                }
                case 4: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    DateFormatUtils.append000(sink, year);
                    continue block33;
                }
                case 1: {
                    if (year == Integer.MIN_VALUE) {
                        year = Timestamps.getYear(micros);
                        leap = Timestamps.isLeapYear(year);
                    }
                    DateFormatUtils.appendEra(sink, year, locale);
                    continue block33;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    sink.put(timeZoneName);
                    continue block33;
                }
                default: {
                    sink.put(this.delimiters.getQuick(-op - 1));
                }
            }
        }
    }

    @Override
    public long parse(CharSequence in, int lo, int hi, TimestampLocale locale) throws NumericException {
        int day = 1;
        int month = 1;
        int year = 1970;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millis = 0;
        int micros = 0;
        int era = 1;
        int timezone = -1;
        long offset = Long.MIN_VALUE;
        int hourType = 2;
        int pos = lo;
        int n = this.compiledOps.size();
        block42: for (int i = 0; i < n; ++i) {
            int op = this.compiledOps.getQuick(i);
            switch (op) {
                case 14: {
                    long l = locale.matchAMPM(in, pos, hi);
                    hourType = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 39: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    micros = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 49: {
                    DateFormatUtils.assertRemaining(pos + 2, hi);
                    micros = Numbers.parseInt(in, pos, pos += 3);
                    continue block42;
                }
                case 149: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    micros = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 21: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    millis = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 31: {
                    DateFormatUtils.assertRemaining(pos + 2, hi);
                    millis = Numbers.parseInt(in, pos, pos += 3);
                    continue block42;
                }
                case 146: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    millis = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 20: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    second = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 30: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    second = Numbers.parseInt(in, pos, pos += 2);
                    continue block42;
                }
                case 145: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    second = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 19: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    minute = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 29: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    minute = Numbers.parseInt(in, pos, pos += 2);
                    continue block42;
                }
                case 144: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    minute = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 17: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos);
                    if (hourType != 2) continue block42;
                    hourType = 0;
                    continue block42;
                }
                case 34: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2);
                    if (hourType != 2) continue block42;
                    hourType = 0;
                    continue block42;
                }
                case 142: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    if (hourType != 2) continue block42;
                    hourType = 0;
                    continue block42;
                }
                case 18: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos) - 1;
                    if (hourType != 2) continue block42;
                    hourType = 0;
                    continue block42;
                }
                case 35: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2) - 1;
                    if (hourType != 2) continue block42;
                    hourType = 0;
                    continue block42;
                }
                case 143: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l) - 1;
                    pos += Numbers.decodeHighInt(l);
                    if (hourType != 2) continue block42;
                    hourType = 0;
                    continue block42;
                }
                case 15: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 32: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2);
                    continue block42;
                }
                case 140: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 16: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    hour = Numbers.parseInt(in, pos++, pos) - 1;
                    continue block42;
                }
                case 33: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    hour = Numbers.parseInt(in, pos, pos += 2) - 1;
                    continue block42;
                }
                case 141: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    hour = Numbers.decodeLowInt(l) - 1;
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 9: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    day = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 10: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    day = Numbers.parseInt(in, pos, pos += 2);
                    continue block42;
                }
                case 139: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    day = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 11: 
                case 12: {
                    long l = locale.matchWeekday(in, pos, hi);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 13: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 5: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    month = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 6: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    month = Numbers.parseInt(in, pos, pos += 2);
                    continue block42;
                }
                case 135: {
                    long l = Numbers.parseIntSafely(in, pos, hi);
                    month = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 7: 
                case 8: {
                    long l = locale.matchMonth(in, pos, hi);
                    month = Numbers.decodeLowInt(l) + 1;
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 2: {
                    DateFormatUtils.assertRemaining(pos, hi);
                    year = Numbers.parseInt(in, pos++, pos);
                    continue block42;
                }
                case 3: {
                    DateFormatUtils.assertRemaining(pos + 1, hi);
                    year = DateFormatUtils.adjustYear(Numbers.parseInt(in, pos, pos += 2));
                    continue block42;
                }
                case 4: {
                    if (pos < hi && in.charAt(pos) == '-') {
                        DateFormatUtils.assertRemaining(pos + 4, hi);
                        year = -Numbers.parseInt(in, pos + 1, pos += 5);
                        continue block42;
                    }
                    DateFormatUtils.assertRemaining(pos + 3, hi);
                    year = Numbers.parseInt(in, pos, pos += 4);
                    continue block42;
                }
                case 132: {
                    long l = DateFormatUtils.parseYearGreedy(in, pos, hi);
                    year = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 1: {
                    long l = locale.matchEra(in, pos, hi);
                    era = Numbers.decodeLowInt(l);
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: {
                    long l = Timestamps.parseOffset(in, pos, hi);
                    if (l == Long.MIN_VALUE) {
                        l = locale.matchZone(in, pos, hi);
                        timezone = Numbers.decodeLowInt(l);
                    } else {
                        offset = (long)Numbers.decodeLowInt(l) * 60000000L;
                    }
                    pos += Numbers.decodeHighInt(l);
                    continue block42;
                }
                default: {
                    String delimiter = this.delimiters.getQuick(-op - 1);
                    int len = delimiter.length();
                    if (len == 1) {
                        DateFormatUtils.assertChar(delimiter.charAt(0), in, pos++, hi);
                        continue block42;
                    }
                    pos = DateFormatUtils.assertString(delimiter, len, in, pos, hi);
                }
            }
        }
        DateFormatUtils.assertNoTail(pos, hi);
        return DateFormatUtils.compute(locale, era, year, month, day, hour, minute, second, millis, micros, timezone, offset, hourType);
    }
}

