/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.microtime;

import io.questdb.std.LongList;
import io.questdb.std.ObjList;
import io.questdb.std.Unsafe;
import io.questdb.std.microtime.TimeZoneRules;
import io.questdb.std.microtime.Timestamps;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.zone.ZoneOffsetTransitionRule;
import java.time.zone.ZoneRules;

public class TimeZoneRulesImpl
implements TimeZoneRules {
    public static final long SAVING_INSTANT_TRANSITION = Unsafe.getFieldOffset(ZoneRules.class, "savingsInstantTransitions");
    public static final long STANDARD_OFFSETS = Unsafe.getFieldOffset(ZoneRules.class, "standardOffsets");
    public static final long LAST_RULES = Unsafe.getFieldOffset(ZoneRules.class, "lastRules");
    public static final long SAVINGS_LOCAL_TRANSITION = Unsafe.getFieldOffset(ZoneRules.class, "savingsLocalTransitions");
    public static final long WALL_OFFSETS = Unsafe.getFieldOffset(ZoneRules.class, "wallOffsets");
    private final long cutoffTransition;
    private final LongList historicTransitions = new LongList();
    private final ObjList<TransitionRule> rules;
    private final int ruleCount;
    private final int[] wallOffsets;
    private final long firstWall;
    private final long lastWall;
    private final int historyOverlapCheckCutoff;
    private final long standardOffset;

    public TimeZoneRulesImpl(ZoneRules rules) {
        long[] savingsInstantTransition = (long[])Unsafe.getUnsafe().getObject(rules, SAVING_INSTANT_TRANSITION);
        if (savingsInstantTransition.length == 0) {
            ZoneOffset[] standardOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, STANDARD_OFFSETS);
            this.standardOffset = (long)standardOffsets[0].getTotalSeconds() * 1000000L;
        } else {
            this.standardOffset = Long.MIN_VALUE;
        }
        for (LocalDateTime dt : (LocalDateTime[])Unsafe.getUnsafe().getObject(rules, SAVINGS_LOCAL_TRANSITION)) {
            this.historicTransitions.add(Timestamps.toMicros(dt.getYear(), dt.getMonthValue(), dt.getDayOfMonth(), dt.getHour(), dt.getMinute()) + (long)dt.getSecond() * 1000000L + (long)(dt.getNano() / 1000));
        }
        this.cutoffTransition = this.historicTransitions.getLast();
        this.historyOverlapCheckCutoff = this.historicTransitions.size() - 1;
        ZoneOffsetTransitionRule[] lastRules = (ZoneOffsetTransitionRule[])Unsafe.getUnsafe().getObject(rules, LAST_RULES);
        this.rules = new ObjList(lastRules.length);
        int n = lastRules.length;
        for (int i = 0; i < n; ++i) {
            ZoneOffsetTransitionRule zr = lastRules[i];
            TransitionRule tr = new TransitionRule();
            tr.offsetBefore = zr.getOffsetBefore().getTotalSeconds();
            tr.offsetAfter = zr.getOffsetAfter().getTotalSeconds();
            tr.standardOffset = zr.getStandardOffset().getTotalSeconds();
            tr.dow = zr.getDayOfWeek() == null ? -1 : zr.getDayOfWeek().getValue();
            tr.dom = zr.getDayOfMonthIndicator();
            tr.month = zr.getMonth().getValue();
            tr.midnightEOD = zr.isMidnightEndOfDay();
            tr.hour = zr.getLocalTime().getHour();
            tr.minute = zr.getLocalTime().getMinute();
            tr.second = zr.getLocalTime().getSecond();
            switch (zr.getTimeDefinition()) {
                case UTC: {
                    tr.timeDef = 0;
                    break;
                }
                case STANDARD: {
                    tr.timeDef = 1;
                    break;
                }
                default: {
                    tr.timeDef = 2;
                }
            }
            this.rules.add(tr);
        }
        this.ruleCount = lastRules.length;
        ZoneOffset[] wallOffsets = (ZoneOffset[])Unsafe.getUnsafe().getObject(rules, WALL_OFFSETS);
        this.wallOffsets = new int[wallOffsets.length];
        int n2 = wallOffsets.length;
        for (int i = 0; i < n2; ++i) {
            this.wallOffsets[i] = wallOffsets[i].getTotalSeconds();
        }
        this.firstWall = (long)this.wallOffsets[0] * 1000000L;
        this.lastWall = (long)this.wallOffsets[wallOffsets.length - 1] * 1000000L;
    }

    @Override
    public long getOffset(long micros, int year, boolean leap) {
        if (this.standardOffset != Long.MIN_VALUE) {
            return this.standardOffset;
        }
        if (this.ruleCount > 0 && micros > this.cutoffTransition) {
            return this.fromRules(micros, year, leap);
        }
        if (micros > this.cutoffTransition) {
            return this.lastWall;
        }
        return this.fromHistory(micros);
    }

    @Override
    public long getOffset(long micros) {
        int y = Timestamps.getYear(micros);
        return this.getOffset(micros, y, Timestamps.isLeapYear(y));
    }

    private long fromHistory(long micros) {
        int index = this.historicTransitions.binarySearch(micros);
        if (index == -1) {
            return this.firstWall;
        }
        if (index < 0) {
            index = -index - 2;
        } else if (index < this.historyOverlapCheckCutoff && this.historicTransitions.getQuick(index) == this.historicTransitions.getQuick(index + 1)) {
            ++index;
        }
        if ((index & 1) == 0) {
            int offsetAfter = this.wallOffsets[index / 2 + 1];
            int offsetBefore = this.wallOffsets[index / 2];
            int delta = offsetAfter - offsetBefore;
            if (delta > 0) {
                return (long)(delta + offsetAfter) * 1000000L;
            }
            return (long)offsetBefore * 1000000L;
        }
        return (long)this.wallOffsets[index / 2 + 1] * 1000000L;
    }

    private long fromRules(long micros, int year, boolean leap) {
        int offset = 0;
        for (int i = 0; i < this.ruleCount; ++i) {
            long date;
            TransitionRule zr = this.rules.getQuick(i);
            offset = zr.offsetBefore;
            int offsetAfter = zr.offsetAfter;
            int dom = zr.dom;
            int month = zr.month;
            int dow = zr.dow;
            if (dom < 0) {
                date = Timestamps.toMicros(year, leap, month, Timestamps.getDaysPerMonth(month, leap) + 1 + dom, zr.hour, zr.minute) + (long)zr.second * 1000000L;
                if (dow > -1) {
                    date = Timestamps.previousOrSameDayOfWeek(date, dow);
                }
            } else {
                date = Timestamps.toMicros(year, leap, month, dom, zr.hour, zr.minute) + (long)zr.second * 1000000L;
                if (dow > -1) {
                    date = Timestamps.nextOrSameDayOfWeek(date, dow);
                }
            }
            if (zr.midnightEOD) {
                date = Timestamps.addDays(date, 1);
            }
            switch (zr.timeDef) {
                case 0: {
                    date += (long)(offset - ZoneOffset.UTC.getTotalSeconds()) * 1000000L;
                    break;
                }
                case 1: {
                    date += (long)(offset - zr.standardOffset) * 1000000L;
                    break;
                }
            }
            long delta = offsetAfter - offset;
            if (delta > 0L) {
                if (micros < date) {
                    return (long)offset * 1000000L;
                }
                if (micros < date + delta) {
                    return ((long)offsetAfter + delta) * 1000000L;
                }
                offset = offsetAfter;
                continue;
            }
            if (micros < date) {
                return (long)offset * 1000000L;
            }
            offset = offsetAfter;
        }
        return (long)offset * 1000000L;
    }

    private static class TransitionRule {
        public static final int UTC = 0;
        public static final int STANDARD = 1;
        public static final int WALL = 2;
        int offsetBefore;
        int offsetAfter;
        int standardOffset;
        int dow;
        int dom;
        int month;
        boolean midnightEOD;
        int hour;
        int minute;
        int second;
        int timeDef;

        private TransitionRule() {
        }
    }
}

