/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.microtime;

import io.questdb.std.ConcurrentHashMap;
import io.questdb.std.microtime.DateFormatCompiler;
import io.questdb.std.microtime.TimestampFormat;
import java.util.function.Function;

public class TimestampFormatFactory {
    private static final ThreadLocal<DateFormatCompiler> tlCompiler = ThreadLocal.withInitial(DateFormatCompiler::new);
    private static final Function<CharSequence, TimestampFormat> mapper = TimestampFormatFactory::map;
    private final ConcurrentHashMap<TimestampFormat> cache = new ConcurrentHashMap();

    private static TimestampFormat map(CharSequence value) {
        return tlCompiler.get().compile(value);
    }

    public TimestampFormat get(CharSequence pattern) {
        return this.cache.computeIfAbsent(pattern, mapper);
    }
}

