/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.std.microtime;

import io.questdb.std.CharSequenceHashSet;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.microtime.TimeZoneRuleFactory;
import io.questdb.std.microtime.TimestampLocale;
import java.text.DateFormatSymbols;
import java.util.Locale;

public class TimestampLocaleFactory {
    public static final TimestampLocaleFactory INSTANCE = new TimestampLocaleFactory(TimeZoneRuleFactory.INSTANCE);
    private final CharSequenceObjHashMap<TimestampLocale> dateLocales = new CharSequenceObjHashMap();
    private final TimestampLocale defaultTimestampLocale;

    public TimestampLocaleFactory(TimeZoneRuleFactory timeZoneRuleFactory) {
        CharSequenceHashSet cache = new CharSequenceHashSet();
        for (Locale l : Locale.getAvailableLocales()) {
            String tag = l.toLanguageTag();
            if ("und".equals(tag)) {
                tag = "";
            }
            this.dateLocales.put(tag, new TimestampLocale(new DateFormatSymbols(l), timeZoneRuleFactory, cache));
            cache.clear();
        }
        this.defaultTimestampLocale = this.dateLocales.get(Locale.getDefault().toLanguageTag());
    }

    public CharSequenceObjHashMap<TimestampLocale> getAll() {
        return this.dateLocales;
    }

    public TimestampLocale getDateLocale(CharSequence id) {
        return this.dateLocales.get(id);
    }

    public TimestampLocale getDefaultTimestampLocale() {
        return this.defaultTimestampLocale;
    }
}

